package com.bailuntec.infrastructure.mapper;

import com.bailuntec.domain.DcFixedAssetsDetail;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * <p>
 * 资产负债表固定资产明细 Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-11-03
 */
public interface DcFixedAssetsDetailMapper extends BaseMapper<DcFixedAssetsDetail> {

    /**
     * 其他应收款
     *
     * @return 其他应收款
     */
    @Select("select ifnull(sum(end_amount),0) from dc_fixed_assets_detail where day = #{lastDay}")
    BigDecimal getFixedAssetsSum(@Param("lastDay") LocalDate lastDay);


    /**
     * 生成一级明细
     *
     * @param date 日期
     */
    void insertFixedAssetsDetail(@Param("date") LocalDate date);

    /**
     * 清空一级明细
     *
     * @param date 日期
     */
    void clearFixedAssetsDetail(@Param("date") LocalDate date);
}
