package com.bailuntec.infrastructure.mapper;

import com.bailuntec.domain.DcBaseFinanceEbay;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Insert;

import java.util.List;

/**
 * <p>
 * ebay费用详情表 gmt_date、item_id、account_entry_type、ref_number作为唯一键 Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
public interface DcBaseFinanceEbayMapper extends BaseMapper<DcBaseFinanceEbay> {

    @Insert("<script>" +
            "insert IGNORE into dc_base_finance_ebay(bj_modified ,account_entry_type ,description ,gmt_date " +
            ",bj_date ,gross_amount ,item_id ,memo ,net_amount ,ref_number ,vat_percent ,title ,order_line_id " +
            ",transaction_id ,company_id ,received_top_rated_discount ,account_id ,currency ,exchange_rate " +
            ",exchange_rate_usd ,report_date) values" +
            "<foreach collection='list' item='item' index='index' separator=','>" +
            "(#{item.bjModified},#{item.accountEntryType},#{item.description},#{item.gmtDate}" +
            ",#{item.bjDate},#{item.grossAmount},#{item.itemId},#{item.memo},#{item.netAmount},#{item.refNumber}" +
            ",#{item.vatPercent},#{item.title},#{item.orderLineId},#{item.transactionId},#{item.companyId}" +
            ",#{item.receivedTopRatedDiscount},#{item.accountId},#{item.currency},#{item.exchangeRate}" +
            ",#{item.exchangeRateUsd},#{item.reportDate})" +
            "</foreach>" +
            "</script>")
    void BatchInsertIgnoreExist(List<DcBaseFinanceEbay> list);
}
