package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in
 * @Modified by:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcSupplierTransaction对象", description="供应商往来数据表(应付账款和预付账款)")
public class DcSupplierTransaction {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "公司主体value")
    private Integer payCompanyValue;

    @ApiModelProperty(value = "公司主体名称")
    private String payCompanyName;

    @ApiModelProperty(value = "供应商ID")
    private Integer supplierId;

    @ApiModelProperty(value = "供应商名称")
    private String supplierName;

    @ApiModelProperty(value = "成品1级供应商数据：1级供应商本身；成品2级供应商数据：对应一级供应商；半成品2级供应商数据：对应付款主体")
    private Integer parentSupplierId;

    @ApiModelProperty(value = "供应商名称")
    private String parentSupplierName;

    @ApiModelProperty(value = "入库金额")
    private BigDecimal puttingAmount;

    @ApiModelProperty(value = "快递费")
    private BigDecimal expressAmount;

    @ApiModelProperty(value = "支付金额")
    private BigDecimal payAmount;

    @ApiModelProperty(value = "退货金额")
    private BigDecimal returnAmount;

    @ApiModelProperty(value = "退货运费")
    private BigDecimal returnExpress;

    @ApiModelProperty(value = "收款金额")
    private BigDecimal receiveAmount;

    @ApiModelProperty(value = "调整金额")
    private BigDecimal adjustAmount;

    @ApiModelProperty(value = "期初金额")
    private BigDecimal startAmount;

    @ApiModelProperty(value = "期末金额")
    private BigDecimal endAmount;

    @ApiModelProperty(value = "统计日期")
    private LocalDateTime day;

    @ApiModelProperty(value = "1：一级供应商，2：二级供应商")
    private Integer types;

    @ApiModelProperty(value = "0：半成品仓，1：成品仓")
    private Integer isFinish;

    @ApiModelProperty(value = "逾期未付款金额")
    private BigDecimal delayNoPayAmount;
}
