package com.bailuntec.job;


import com.bailuntec.job.service.SyncCashierService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Slf4j
@Component
public class CashierJob {

    @Resource
    SyncCashierService syncCashierService;

    /**
     * 每秒同步流水
     */
    @Scheduled(cron = "0 0/1 * * * ?")
    public void syncCashier() {
        try {
            log.info("每分钟 同步流水 开始");
            syncCashierService.syncCashier();
            log.info("每分钟 同步流水 结束");
        } catch (Exception ex) {
            log.error("每分钟 同步流水 异常:", ex);
        }
    }

    /**
     * 每秒同步流水
     */
    @Scheduled(cron = "0 0/1 * * * ?")
    public void syncWithdraw() {
        try {
            log.info("每秒同步流水详情 开始");
            syncCashierService.syncWithdraw();
            log.info("每秒同步流水详情 结束");
        } catch (Exception ex) {
            log.error("每秒同步流水详情 异常:", ex);
        }

    }


    /**
     * 每分钟 同步利息支出
     */
    @Scheduled(cron = "0 0/1 * * * ?")
    public void syncInterest() {
        try {
            log.info("每分钟 同步利息支出 开始");
            syncCashierService.syncInterest();
            log.info("每分钟 同步利息支出 结束");
        } catch (Exception ex) {
            log.error("每分钟 同步利息支出 异常:", ex);
        }

    }

    /**
     * 每分钟 同步利息支出
     */
    @Scheduled(cron = "0 0/1 * * * ?")
    public void syncHandleFee() {
        try {
            log.info("每分钟 同步流水详情 开始");
            syncCashierService.syncHandleFee();
            log.info("每分钟 同步流水详情 结束");
        } catch (Exception ex) {
            log.error("每分钟 同步流水详情 异常:", ex);
        }

    }
}
