package com.bailuntec.job;


import com.bailuntec.job.service.DailySnapshotService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Slf4j
@Component
public class DailySnapshotJob {

    @Resource
    DailySnapshotService dailySnapshotService;

    @Scheduled(cron = "0 0/1 * * * ?")
    public void baseSyncFinanceFee() {
        try {
            log.info("每分钟同步费用单 开始");
            dailySnapshotService.saveDcBastStockDailySnapshot();
            log.info("每分钟同步费用单 结束");
        } catch (Exception ex) {
            log.error("每分钟同步费用单 异常:", ex);
        }
    }


}
