package com.bailuntec.job;


import com.bailuntec.job.service.TurnoverPrepareService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Slf4j
@Component
public class TurnoverPrepareJob {

    @Resource
    TurnoverPrepareService turnoverPrepareService;

    /**
     * <p>
     * 每10分钟同步
     * <li>oms</li>
     * 但环球库存不存在的库存
     * 到库存表
     * </p>
     */
    @Scheduled(cron = "0 0/10 * * * ? ")
    public void syncBaseStock() {
        try {
            log.info("每10分钟同步oms存在sku但环球库存不存在的库存到库存表 开始");
            turnoverPrepareService.supplyOrderSku();
            log.info("每10分钟同步oms存在sku但环球库存不存在的库存到库存表 结束");
        } catch (Exception e) {
            log.error("每10分钟同步oms、在途、采购存在sku但环球库存不存在的库存到库存表 失败", e);
        }
    }

    /**
     * <p>
     * 每10分钟同步
     * <li>采购</li>存在sku
     * 但环球库存不存在的库存
     * 到库存表
     * </p>
     */
    @Scheduled(cron = "0 0/10 * * * ? ")
    public void supplyPurchaseSku() {
        try {
            log.info("每10分钟同步采购存在sku但环球库存不存在的库存到库存表 开始");
            turnoverPrepareService.supplyPurchaseSku();
            log.info("每10分钟同步采购存在sku但环球库存不存在的库存到库存表 结束");
        } catch (Exception e) {
            log.error("每10分钟同步采购存在sku但环球库存不存在的库存到库存表 失败", e);
        }
    }

    /**
     * <p>
     * 每10分钟同步
     * <li>在途</li>
     * 但环球库存不存在的库存
     * 到库存表
     * </p>
     */
    @Scheduled(cron = "0 0/10 * * * ? ")
    public void supplyTransitSku() {
        try {
            log.info("每10分钟同步在途存在sku但环球库存不存在的库存到库存表 开始");
            turnoverPrepareService.supplyTransitSku();
            log.info("每10分钟同步在途存在sku但环球库存不存在的库存到库存表 结束");
        } catch (Exception e) {
            log.error("每10分钟同步在途存在sku但环球库存不存在的库存到库存表 失败", e);
        }
    }

}
