package com.bailuntec.job.service;

import com.bailuntec.common.BeanUtils;
import com.bailuntec.common.ListUtil;
import com.bailuntec.cost.api.CostApi;
import com.bailuntec.cost.api.dto.CostDto;
import com.bailuntec.cost.api.dto.ManageCostDto;
import com.bailuntec.cost.api.response.CostResult;
import com.bailuntec.domain.DcBaseFinanceFee;
import com.bailuntec.domain.DcBaseFinanceLogistics;
import com.bailuntec.domain.DcBaseFinanceManagecost;
import com.bailuntec.domain.DcJobConfig;
import com.bailuntec.infrastructure.mapper.DcBaseFinanceFeeMapper;
import com.bailuntec.infrastructure.mapper.DcBaseFinanceLogisticsMapper;
import com.bailuntec.infrastructure.mapper.DcBaseFinanceManagecostMapper;
import com.bailuntec.infrastructure.mapper.DcJobConfigMapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/7 11:38 上午
 */
@Slf4j
@Service
public class SyncFeeService {

    public static final String baseSyncFinanceFee = "base-sync-finance-fee";
    public static final String baseSyncLogistics = "base-sync-logistics";
    public static final String baseSyncManageCost = "base-sync-manage-cost";
    public static final String baseSyncDailyFee = "base-sync-daily-fee";

    @Resource
    DcJobConfigMapper dcJobConfigMapper;
    @Resource
    DcBaseFinanceFeeMapper dcBaseFinanceFeeMapper;
    @Resource
    DcBaseFinanceLogisticsMapper dcBaseFinanceLogisticsMapper;
    @Resource
    CostApi costApi;
    @Resource
    DcBaseFinanceManagecostMapper dcBaseFinanceManagecostMapper;


    @Transactional
    public void syncFinanceFee() {
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(baseSyncFinanceFee);
        Integer pageNum = 1;
        Integer pageSize = 100;
        for (; ; ) {
            CostResult<List<CostDto>> result = costApi.getCostList(dcJobConfig.getStartTimeStr(),
                    dcJobConfig.getEndTimeStr(),
                    pageNum,
                    pageSize);

            if (ListUtil.isEmpty(result.getData())) {
                break;
            }
            result.getData().forEach(costDto -> {
                DcBaseFinanceFee dcBaseFinanceFee = new DcBaseFinanceFee();
                BeanUtils.copyProperties(costDto, dcBaseFinanceFee, "id");
                dcBaseFinanceFee.setCreateTime(LocalDateTime.ofInstant(costDto.getCreateTime().toInstant(), ZoneId.systemDefault()));
                dcBaseFinanceFee.setBjModified(LocalDateTime.now());
                //更新
                int update = dcBaseFinanceFeeMapper.update(dcBaseFinanceFee, new LambdaQueryWrapper<DcBaseFinanceFee>()
                        .eq(DcBaseFinanceFee::getCostNo, dcBaseFinanceFee.getCostNo()));
                //插入
                if (update == 0) {
                    dcBaseFinanceFee.setBjCreate(LocalDateTime.now());
                    dcBaseFinanceFeeMapper.insert(dcBaseFinanceFee);
                }
                log.info("同步一条费用单,costNo:{}", costDto.getCostNo());
            });
            pageNum++;
        }

        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }

    @Transactional
    public void syncLogistics() {
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(baseSyncLogistics);

        CostResult<List<ManageCostDto>> result = costApi.logisticsCostList(dcJobConfig.getStartTimeStr(),
                dcJobConfig.getEndTimeStr(),
                null, null, null, null, null, null, null
        );

        //重跑的时候clear保证方法幂等
        dcBaseFinanceLogisticsMapper.delete(new LambdaQueryWrapper<DcBaseFinanceLogistics>()
                .gt(DcBaseFinanceLogistics::getPayTime, dcJobConfig.getStartTime())
                .lt(DcBaseFinanceLogistics::getPayTime, dcJobConfig.getEndTime()));

        result.getData().forEach(manageCostDto -> {
            DcBaseFinanceLogistics dcBaseFinanceLogistics = new DcBaseFinanceLogistics();
            BeanUtils.copyProperties(manageCostDto, dcBaseFinanceLogistics, "id");
            dcBaseFinanceLogistics.setGmtModified(LocalDateTime.now());
            dcBaseFinanceLogistics.setPayTime(manageCostDto.getPayTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
            int update = dcBaseFinanceLogisticsMapper.update(dcBaseFinanceLogistics, new LambdaQueryWrapper<DcBaseFinanceLogistics>()
                    .eq(DcBaseFinanceLogistics::getNo, dcBaseFinanceLogistics.getNo())
                    .eq(DcBaseFinanceLogistics::getCostId1, dcBaseFinanceLogistics.getCostId1())
                    .eq(DcBaseFinanceLogistics::getCostId, dcBaseFinanceLogistics.getCostId()));

            if (update == 0) {
                dcBaseFinanceLogisticsMapper.insert(dcBaseFinanceLogistics);
            }
        });

        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }

    @Transactional
    public void syncManageCost() {
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(baseSyncManageCost);

        CostResult<List<ManageCostDto>> result = costApi.manageCostList(dcJobConfig.getStartTimeStr(),
                dcJobConfig.getEndTimeStr(),
                null, null, null, null, null, null, null
        );

        //重跑的时候clear保证方法幂等
        dcBaseFinanceManagecostMapper.delete(new LambdaQueryWrapper<DcBaseFinanceManagecost>()
                .gt(DcBaseFinanceManagecost::getPayTime, dcJobConfig.getStartTime())
                .lt(DcBaseFinanceManagecost::getPayTime, dcJobConfig.getEndTime()));

        //同步
        result.getData().forEach(manageCostDto -> {
            DcBaseFinanceManagecost dcBaseFinanceManagecost = new DcBaseFinanceManagecost();
            BeanUtils.copyProperties(manageCostDto, dcBaseFinanceManagecost, "id");
            dcBaseFinanceManagecost.setGmtModifyTime(LocalDateTime.now());
            dcBaseFinanceManagecost.setPayTime(manageCostDto.getPayTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());

            int update = dcBaseFinanceManagecostMapper.update(dcBaseFinanceManagecost, new LambdaQueryWrapper<DcBaseFinanceManagecost>()
                    .eq(DcBaseFinanceManagecost::getNo, dcBaseFinanceManagecost.getNo())
                    .eq(DcBaseFinanceManagecost::getCostId1, dcBaseFinanceManagecost.getCostId1())
                    .eq(DcBaseFinanceManagecost::getCostId, dcBaseFinanceManagecost.getCostId()));

            if (update == 0) {
                dcBaseFinanceManagecostMapper.insert(dcBaseFinanceManagecost);
            }
        });

        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }

    @Transactional
    public void syncDailyFee() {
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(baseSyncDailyFee);
        LocalDate date = dcJobConfig.getStartTime().toLocalDate();
        dcBaseFinanceFeeMapper.deleteDailyFee(date);
        dcBaseFinanceFeeMapper.insertDailyFee(date);

        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }


}
