package com.bailuntec.job;


import com.bailuntec.job.service.SyncFeeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Slf4j
@Component
public class FeeJob {

    @Resource
    SyncFeeService syncFeeService;

    @Scheduled(cron = "0/10 * * * * ?")
    public void baseSyncFinanceFee() {
        try {
            log.info("每分钟同步费用单 开始");
            syncFeeService.syncFinanceFee();
            log.info("每分钟同步费用单 结束");
        } catch (Exception ex) {
            log.error("每分钟同步费用单 异常:", ex);
        }
    }


    @Scheduled(cron = "0/10 * * * * ?")
    public void syncLogistics() {
        try {
            log.info("每分钟同步物流费用 开始");
            syncFeeService.syncLogistics();
            log.info("每分钟同步物流费用 结束");
        } catch (Exception ex) {
            log.error("每分钟同步物流费用 异常:", ex);
        }
    }

    @Scheduled(cron = "0/10 * * * * ?")
    public void syncManageCost() {
        try {
            log.info("每分钟同步管理成本 开始");
            syncFeeService.syncManageCost();
            log.info("每分钟同步管理成本 结束");
        } catch (Exception ex) {
            log.error("每分钟同步管理成本 异常:", ex);
        }
    }


    @Scheduled(cron = "0/10 * * * * ?")
    public void syncDailyFee() {
        try {
            log.info("每分钟同步当天费用单 开始");
            syncFeeService.syncDailyFee();
            log.info("每分钟同步当天费用单 结束");
        } catch (Exception ex) {
            log.error("每分钟同步当天费用单 异常:", ex);
        }
    }

}
