package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 存货余额表
 * </p>
 *
 * @author robbendev
 * @since 2020-11-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcInventoryBalance对象", description="存货余额表")
public class DcInventoryBalance implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "仓库代码")
    private String warehouseCode;

    @ApiModelProperty(value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(value = "环球仓库类型")
    private String hqType;

    @ApiModelProperty(value = "是否调拨在途：0-否；1-是")
    private Integer isTransfer;

    @ApiModelProperty(value = "存货余额/库存金额")
    private BigDecimal balanceRmb;

    @ApiModelProperty(value = "调拨在途金额")
    private BigDecimal transferRmb;

    @ApiModelProperty(value = "调拨计划在途金额")
    private BigDecimal transferPlanRmb;

    @ApiModelProperty(value = "采购在途金额")
    private BigDecimal purchaseRmb;

    @ApiModelProperty(value = "统计时间")
    private LocalDate statisticalTime;

    @ApiModelProperty(value = "取数时间")
    private LocalDateTime updateTime;


}
