package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 仓库平均指标
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcAverageWarehouse对象", description="仓库平均指标")
public class DcAverageWarehouse implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "sku")
    private String bailunSku;

    @ApiModelProperty(value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(value = "平均入库天数")
    private Integer inboundDays;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "海运平均调拨天数")
    private BigDecimal transferType1Days;

    @ApiModelProperty(value = "空运平均调拨天数")
    private BigDecimal transferType2Days;

    @ApiModelProperty(value = "调拨打包天数")
    private BigDecimal transferBaleDelivery;

    @ApiModelProperty(value = "海外仓入库天数")
    private BigDecimal abroadInboundDelivery;

    @ApiModelProperty(value = "调拨头程天数")
    private BigDecimal transferDelivery;


}
