package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * jit 备货天数配置
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "DcAutoJitTag对象", description = "jit 备货天数配置")
public class DcAutoJitTag implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "标签名字")
    private String tagName;

    @ApiModelProperty(value = "是否大于指标 7 日指标 1= 大于 2  =等于 3 = 小于 4 = 大于等于 5 = 小于等于")
    private Integer isGt7;

    @ApiModelProperty(value = "7日销量的算法，是否启用：0未启用、1启用")
    private Integer enable7;

    @ApiModelProperty(value = "过去7日销量")
    private BigDecimal quantitySales7;

    @ApiModelProperty(value = "是否大于指标 14 日指标 1= 大于 2  =等于 3 = 小于 4 = 大于等于 5 = 小于等于")
    private Integer isGt14;

    @ApiModelProperty(value = "14日销量的算法，是否启用：0未启用、1启用")
    private Integer enable14;

    @ApiModelProperty(value = "过去14日销量")
    private BigDecimal quantitySales14;

    @ApiModelProperty(value = "是否大于指标 30 日指标 1= 大于 2  =等于 3 = 小于 4 = 大于等于 5 = 小于等于")
    private Integer isGt30;

    @ApiModelProperty(value = "30日销量的算法，是否启用：0未启用、1启用")
    private Integer enable30;

    @ApiModelProperty(value = "过去30日销量")
    private BigDecimal quantitySales30;

    @ApiModelProperty(value = "安全库存天数")
    private BigDecimal quantitySafeInventory;

    @ApiModelProperty(value = "优先级别")
    private Integer level;

    @ApiModelProperty(value = "是否淘汰：0 开启备货、1 只补缺货")
    private Integer isEliminate;

    @ApiModelProperty(value = "最后修改时间")
    private LocalDateTime gmtUpdate;

    @ApiModelProperty(value = "分组id")
    private Integer groupId;

    @ApiModelProperty(value = "采购员名称")
    private String buyerName;


}
