package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 资产负债表固定资产明细
 * </p>
 *
 * @author robbendev
 * @since 2020-11-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcFixedAssetsDetail对象", description="资产负债表固定资产明细")
public class DcFixedAssetsDetail implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "统计日期")
    private LocalDate day;

    @ApiModelProperty(value = "公司主体value")
    private Integer companyValue;

    @ApiModelProperty(value = "采购公司")
    private String companyName;

    @ApiModelProperty(value = "期初金额")
    private BigDecimal startAmount;

    @ApiModelProperty(value = "借方发生额")
    private BigDecimal debitAmount;

    @ApiModelProperty(value = "贷方发生额")
    private BigDecimal creditAmount;

    @ApiModelProperty(value = "期末金额")
    private BigDecimal endAmount;

    @ApiModelProperty(value = "取数时间")
    private LocalDateTime updateTime;


}
