package com.bailuntec.job;


import com.bailuntec.job.service.BalanceSheetService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

@Slf4j
@Component
public class BalanceSheetJob {

    @Resource
    BalanceSheetService balanceSheetService;

    @Scheduled(cron = "0 0 1 * * ?")
    public void syncBankAccount() {
        try {
            log.info("每天1点同步 银行帐号信息 开始");
            balanceSheetService.syncBankAccount();
            log.info("每天1点同步 银行帐号信息 结束");
        } catch (Exception ex) {
            log.error("每天1点同步 银行帐号信息 异常:", ex);
        }
    }

    /**
     * 同步提现在途
     */
    @Scheduled(cron = "0 0 1 * * ?")
    public void syncWithdrawOnWaySummary() {
        try {
            log.info("每天1点 同步提现在途 开始");
            balanceSheetService.syncWithdrawOnWaySummary();
            log.info("每天1点 同步提现在途 结束");
        } catch (Exception ex) {
            log.error("每天1点 同步提现在途 异常:", ex);
        }
    }

    /**
     * 同步第三方帐号余额
     */
    @Scheduled(cron = "0 0 1 * * ?")
    public void syncPayPal() {
        try {
            log.info("每天1点 同步第三方余额 开始");
            balanceSheetService.syncPayPal();
            log.info("每天1点 同步第三方余额 结束");
        } catch (Exception ex) {
            log.error("每天1点 同步第三方余额 异常:", ex);
        }
    }


    /**
     * 同步短期借款余额
     */
    @Scheduled(cron = "0 0 1 * * ?")
    @Transactional(rollbackFor = Exception.class)
    public void syncShortBorrowBalance() {
        try {
            log.info("每天1点 同步提现在途 开始");
            balanceSheetService.syncShortBorrowBalance();
            log.info("每天1点 同步提现在途 结束");
        } catch (Exception ex) {
            log.error("每天1点 同步提现在途 异常:", ex);
        }
    }

    /**
     * 同步数据中心需要的费用单
     */
    //@Scheduled(cron = "0 0 1 * * ?")
    public void syncCost() {
        try {
            log.info("每天1点 同步数据中心需要的费用单 开始");
            balanceSheetService.syncCost();
            log.info("每天1点 同步数据中心需要的费用单 结束");
        } catch (Exception ex) {
            log.error("每天1点 同步数据中心需要的费用单 异常:", ex);
        }
    }


    /**
     * 同步费用系统采购单：固定资产
     */
    @Scheduled(cron = "0 0 1 * * ?")
    public void syncBuy() {
        try {
            log.info("每天1点 同步费用系统采购单 开始");
            balanceSheetService.syncBuy();
            log.info("每天1点 同步费用系统采购单 结束");
        } catch (Exception ex) {
            log.error("每天1点 同步费用系统采购单 异常:", ex);
        }
    }

    /**
     * <p>
     * 每天生成半成品数据
     * </p>
     */
    @Scheduled(cron = "0 0 1 * * ?")
    public void syncSemiInventoryBalance() {
        try {
            log.info("每天 生成半成品数据 开始");
            balanceSheetService.syncSemiInventoryBalance();
            log.info("每天 生成半成品数据 结束");
        } catch (Exception ex) {
            log.error("每天 生成半成品数据 异常:", ex);
        }
    }

    /**
     * 每周六日获取物流供应商往来数据
     */
    @Scheduled(cron = "0 0 2 ? 1-12 1,7")
    public void syncLogisticsSupplierTransaction() {
        try {
            log.info("每周六日 获取物流供应商往来数据 开始");
            balanceSheetService.getLogisticsSupplierTransaction();
            log.info("每周六日 获取物流供应商往来数据 结束");
        } catch (Exception ex) {
            log.error("每周六日 获取物流供应商往来数据 异常:", ex);
        }
    }

    /**
     * 每天 生成资产负债表
     * companyValue 0
     * companyName 百伦供应链
     * <p>
     * {@link}
     * </p>
     * 数据来源
     */
    @Scheduled(cron = "0 0 3 * * ?")
    public void generateBalanceSheet() {
        try {
            log.info("每天3点 生成资产负债表 开始");
            balanceSheetService.generateBalanceSheet();
            log.info("每天3点 生成资产负债表 结束");
        } catch (Exception ex) {
            log.error("每天3点 生成资产负债表 异常:", ex);
        }
    }

    @Scheduled(cron = "0 0 4 * * ?")
    public void getSupplierTransaction() {
        try {
            log.info("每天4点 取供应商往来数据：应付账款和预付账款 开始");//
            balanceSheetService.getSupplierTransaction();
            log.info("每天4点 取供应商往来数据：应付账款和预付账款 结束");
        } catch (Exception ex) {
            log.error("每天4点 取供应商往来数据：应付账款和预付账款 异常:", ex);
        }
    }

    /**
     * 每天 生成新资产负债结果表
     * companyValue 0
     * companyName 百伦供应链
     * <p>
     * {@link}
     * </p>
     * 数据来源
     */
    @Scheduled(cron = "0 0 7 * * ?")
    public void generateBalanceSheetNewResult() {
        try {
            log.info("每天7点 生成新资产负债结果表 开始");
            balanceSheetService.generateBalanceSheetNewResult();
            log.info("每天7点 生成新资产负债结果表 结束");
        } catch (Exception ex) {
            log.error("每天7点 生成新资产负债结果表 异常:", ex);
        }
    }

}
