package com.bailuntec.infrastructure.mapper;

import com.bailuntec.domain.DcBaseStock;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 实时环球库存信息表 Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
public interface DcBaseStockMapper extends BaseMapper<DcBaseStock> {

    /**
     * <p>同步订单sku有但是库存sku没有的sku到库存表中
     *
     * </p>
     */
    void supplementOrderSku();

    /**
     * <p>
     * 同步采购sku有但是库存没有的sku到库存表中
     * </p>
     */
    void supplementPurchaseSku();

    /**
     * <p>
     * 同步在途有但是库存没有的sku到库存表中
     * </p>
     */
    void supplementTransitSku();

    /**
     * 查询订单sku有但是库存sku不存在的数据
     *
     * @param pageStart
     * @param pageOffset
     * @return sku+warehouse_code直接映射到实体
     */
    List<DcBaseStock> selectSupplyOrderSku(@Param("pageStart") int pageStart, @Param("pageOffset") int pageOffset);

    /**
     * 查询采购sku有但是库存表不存在的数据
     *
     * @param pageStart
     * @param pageOffset
     * @return warehouse_code直接映射到实体
     */
    List<DcBaseStock> selectSupplyPurchaseSku(@Param("pageStart") int pageStart, @Param("pageOffset") int pageOffset);

    /**
     * 查询在途（采购在途+调拨在途）存在的sku但是库存表不存在的数据
     *
     * @param pageStart
     * @param pageOffset
     * @return warehouse_code直接映射到实体
     */
    List<DcBaseStock> selectSupplyTransitSku(@Param("pageStart") int pageStart, @Param("pageOffset") int pageOffset);
}
