package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 自动周转预测断货和冗余波动
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcAutoForecastFluctuation对象", description="自动周转预测断货和冗余波动")
public class DcAutoForecastFluctuation implements Serializable {

    private static final long serialVersionUID = 1L;

    private LocalDateTime gmtCreate;

    private LocalDateTime gmtModified;

    private String bailunSku;

    @ApiModelProperty(value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(value = "yyyy-M-dd 开始时间,若只配置单个当天时间, 放在在这里")
    private LocalDate startTime;

    @ApiModelProperty(value = "yyyy-M-dd 结束时间")
    private LocalDate endTime;

    @ApiModelProperty(value = "操作员")
    private String blOperator;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "备注或者解决方法")
    private String remark;

    @ApiModelProperty(value = "是否解决")
    private Boolean hasSolve;

    @ApiModelProperty(value = "预计解决时间")
    private LocalDateTime forecastSolveTime;

    @ApiModelProperty(value = "是否确认")
    private Boolean hasConfirm;

    @ApiModelProperty(value = "确认时间")
    private LocalDateTime confirmTime;

    @ApiModelProperty(value = "1实际缺货2预计缺货3实际冗余4预计冗余5断货")
    private Integer type;

    @ApiModelProperty(value = "3天平均销量")
    private BigDecimal avgSalesThree;

    @ApiModelProperty(value = "Type对应的数量")
    private Integer quantity;


}
