package com.bailuntec.job.service;

import com.bailuntec.application.IDcDailyStockService;
import com.bailuntec.application.IDcDailyTransitService;
import com.bailuntec.common.ListUtil;
import com.bailuntec.domain.DcDailyStock;
import com.bailuntec.domain.DcDailyTransit;
import com.bailuntec.domain.DcJobConfig;
import com.bailuntec.infrastructure.mapper.DcDailyStockMapper;
import com.bailuntec.infrastructure.mapper.DcDailyTransitMapper;
import com.bailuntec.infrastructure.mapper.DcJobConfigMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/7 11:38 上午
 */
@Slf4j
@Service
public class DailySnapshotService {

    @Resource
    IDcDailyStockService dcDailyStockService;
    @Resource
    DcDailyStockMapper dcDailyStockMapper;
    @Resource
    DcJobConfigMapper dcJobConfigMapper;
    @Resource
    DcDailyTransitMapper dcDailyTransitMapper;
    @Resource
    IDcDailyTransitService dcDailyTransitService;

    private final static String baseStockDailySnapshot = "base-stock-daily-snapshot";
    private final static String midTransitDailySnapshot = "mid-transit-daily-snapshot";


    /**
     * 每天0点10分
     * 保存库存每日快照
     */
    @Transactional
    public void saveDcBastStockDailySnapshot() {

        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(baseStockDailySnapshot);
        int pageNum = dcJobConfig.getPageNum();
        int pageSize = dcJobConfig.getPageSize();

        dcDailyStockMapper.clearSnapShot();
        for (; ; ) {
            List<DcDailyStock> dcBaseStockList = dcDailyStockMapper.selectSnapShot((pageNum - 1) * pageSize, pageSize);
            if (ListUtil.isEmpty(dcBaseStockList)) {
                break;
            }
            dcDailyStockService.saveBatch(dcBaseStockList);
            pageNum++;
            dcJobConfig.setPageNum(pageNum);
            dcJobConfigMapper.updateById(dcJobConfig);
        }
        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }

    /**
     * 每天0点10分
     * 保存库存每日快照
     */
    public void saveDcBaseOmsSku30SnapShot() {
    }

    /**
     * 每天0点10分
     * 保存周转在途快照
     */
    public void saveMidTransitSnapShot() {
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(midTransitDailySnapshot);
        int pageNum = dcJobConfig.getPageNum();
        int pageSize = dcJobConfig.getPageSize();

        dcDailyTransitMapper.clearSnapShot();
        for (; ; ) {
            List<DcDailyTransit> dcDailyTransitList = dcDailyTransitMapper.selectSnapShot((pageNum - 1) * pageSize, pageSize);
            if (ListUtil.isEmpty(dcDailyTransitList)) {
                break;
            }

            dcDailyTransitService.saveBatch(dcDailyTransitList);
            pageNum++;
            dcJobConfig.setPageNum(pageNum);
            dcJobConfigMapper.updateById(dcJobConfig);
        }
        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }
}
