package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 百伦OMS订单-平台SKU维度
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseOmsPlatformSku对象", description="百伦OMS订单-平台SKU维度")
public class DcBaseOmsPlatformSku implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "平台订单号")
    private String originOrderId;

    @ApiModelProperty(value = "平台类型")
    private String platformType;

    @ApiModelProperty(value = "交易号")
    private String transactionId;

    @ApiModelProperty(value = "支付时间-平台站点时间")
    private LocalDateTime payTimeSite;

    @ApiModelProperty(value = "支付时间-北京时间")
    private LocalDateTime payTime;

    @ApiModelProperty(value = "支付方法")
    private String payMethod;

    @ApiModelProperty(value = "支付账号")
    private String payAccount;

    @ApiModelProperty(value = "支付状态")
    private String payStatus;

    @ApiModelProperty(value = "收款账号")
    private String collectionAccount;

    @ApiModelProperty(value = "平台订单类型")
    private String platformOrderType;

    @ApiModelProperty(value = "站点")
    private String website;

    @ApiModelProperty(value = "订单创建时间-北京时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "订单创建时间-平台站点时间")
    private LocalDateTime createTimeSite;

    @ApiModelProperty(value = "订单付款时间-平台站点时间")
    private LocalDateTime paidTimeSite;

    @ApiModelProperty(value = "订单付款时间-北京时间")
    private LocalDateTime paidTime;

    @ApiModelProperty(value = "销售账号Id")
    private String sellerId;

    @ApiModelProperty(value = "账号id")
    private Integer bailunAccountId;

    @ApiModelProperty(value = "销售账号")
    private String sellerAccount;

    @ApiModelProperty(value = "暂时不知道意思")
    private String sellerOrderId;

    @ApiModelProperty(value = "销售账号邮箱")
    private String sellerEmail;

    @ApiModelProperty(value = "订单更新时间-北京时间")
    private LocalDateTime orderUpdateTime;

    @ApiModelProperty(value = "销售订单汇率-转人民币")
    private BigDecimal sellerOrderExchangeRate;

    @ApiModelProperty(value = "财务订单汇率-转人民币")
    private BigDecimal financeOrderExchangeRate;

    @ApiModelProperty(value = "人民币转美元汇率")
    private BigDecimal cnyToUsdExchangeRate;

    @ApiModelProperty(value = "Order币种转美元汇率")
    private BigDecimal orderToUsdExchangeRate;

    @ApiModelProperty(value = "订单币种")
    private String orderCurrency;

    @ApiModelProperty(value = "销售员")
    private String sellerName;

    @ApiModelProperty(value = "百伦订单号")
    private String bailunOrderId;

    @ApiModelProperty(value = "平台订单状态")
    private String platformOrderStatus;

    @ApiModelProperty(value = "百伦订单状态")
    private String bailunOrderStatus;

    @ApiModelProperty(value = "百伦付款状态")
    private String bailunPaymentStatus;

    @ApiModelProperty(value = "百伦拦截状态")
    private String bailunInterceptionStatus;

    @ApiModelProperty(value = "百伦发货状态")
    private String shippingStatus;

    @ApiModelProperty(value = "平台SKU")
    private String platformSku;

    @ApiModelProperty(value = "itemId")
    private String itemId;

    @ApiModelProperty(value = "平台SKU英文标题")
    private String platformSkuTitleEn;

    @ApiModelProperty(value = "平台SKU中文标题")
    private String platformSkuTitleCn;

    @ApiModelProperty(value = "平台SKU订单数量")
    private Integer platformSkuQuantityOrdered;

    @ApiModelProperty(value = "平台SKU发货数量")
    private Integer platformSkuQuantityShipped;

    @ApiModelProperty(value = "平台SKU单价")
    private BigDecimal platformSkuUnitPrice;

    @ApiModelProperty(value = "收货国家")
    private String receiptCountry;

    @ApiModelProperty(value = "收货城市")
    private String receiptCity;

    @ApiModelProperty(value = "收货州或区域")
    private String receiptArea;

    @ApiModelProperty(value = "收货街道")
    private String receiptAddress;

    @ApiModelProperty(value = "收货门牌")
    private String receiptAddress2;

    @ApiModelProperty(value = "收货邮编")
    private String receiptPostalCode;

    @ApiModelProperty(value = "收货人")
    private String receiver;

    @ApiModelProperty(value = "收货电话")
    private String receiverPhone;

    @ApiModelProperty(value = "买家账号Id")
    private String buyerId;

    @ApiModelProperty(value = "买家账号")
    private String buyerName;

    @ApiModelProperty(value = "买家邮箱")
    private String buyerEmail;

    @ApiModelProperty(value = "是否被平台取消-来自OMS")
    private Boolean hasCancle;

    @ApiModelProperty(value = "区域Id")
    private Integer areaId;

    @ApiModelProperty(value = "数据中心创建时间")
    private LocalDateTime gmtCreate;

    @ApiModelProperty(value = "数据中心更新时间")
    private LocalDateTime gmtModified;

    @ApiModelProperty(value = "是否删除-数据中心判断")
    private Boolean hasDelete;

    @ApiModelProperty(value = "是否刷单订单")
    private Boolean hasScalp;

    @ApiModelProperty(value = "公司Id, 默认0是无意义的")
    private Integer companyId;


}
