package com.bailuntec.interfaces;

import com.bailuntec.application.IDcBalanceSheetNewModifyService;
import com.bailuntec.common.base.BaseResult;
import com.bailuntec.domain.DcBalanceSheetNewModify;
import com.bailuntec.job.service.BalanceSheetService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/12/3 1:41 下午
 */
@Api(tags = "资产负债表接口")
@RestController
@RequestMapping("/balanceSheetModify")
public class BalanceSheetModifyController {

    @Resource
    IDcBalanceSheetNewModifyService dcBalanceSheetNewModifyService;
    @Resource
    BalanceSheetService balanceSheetService;

    @ApiOperation("资产负债表录入")
    @PostMapping("/record")
    public BaseResult<Void> record(@RequestBody DcBalanceSheetNewModify dcBalanceSheetNewModify) {
        dcBalanceSheetNewModifyService.record(dcBalanceSheetNewModify);
        balanceSheetService.setBalanceSheetNewResult(dcBalanceSheetNewModify.getStatisticalTime());
        return BaseResult.success();
    }
}
