package com.bailuntec.job.service;

import com.bailuntec.api.bailuntec.oms.OmsApi;
import com.bailuntec.application.IDcBaseOmsSku30Service;
import com.bailuntec.application.IDcBaseOmsSkuService;
import com.bailuntec.application.IDcBaseOmsSkuTransferService;
import com.bailuntec.common.BeanUtils;
import com.bailuntec.common.ListUtil;
import com.bailuntec.domain.DcBaseOmsSku;
import com.bailuntec.domain.DcBaseOmsSku30;
import com.bailuntec.domain.DcBaseOmsSkuTransfer;
import com.bailuntec.domain.DcJobConfig;
import com.bailuntec.infrastructure.mapper.DcBaseOmsSku30Mapper;
import com.bailuntec.infrastructure.mapper.DcBaseOmsSkuMapper;
import com.bailuntec.infrastructure.mapper.DcJobConfigMapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/7 11:38 上午
 */
@Slf4j
@Service
public class SyncOmsOrder {

    private final static String baseSyncOmsOrder = "base-sync-oms-order";
    private final static String baseSyncOmsSku30 = "base-sync-oms-sku30";
    private final static String baseSyncOmsSku302 = "base-sync-oms-sku302";

    @Resource
    DcJobConfigMapper dcJobConfigMapper;
    @Resource
    OmsApi omsApi;
    @Resource
    DcBaseOmsSkuMapper dcBaseOmsSkuMapper;
    @Resource
    DcBaseOmsSku30Mapper dcBaseOmsSku30Mapper;
    @Resource
    IDcBaseOmsSku30Service dcBaseOmsSku30Service;

    @Transactional
    public void syncOmsOrder() {
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(baseSyncOmsOrder);

//        omsApi.getBailunOrders()

        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }

    @Resource
    IDcBaseOmsSkuService dcBaseOmsSkuService;
    @Resource
    IDcBaseOmsSkuTransferService dcBaseOmsSkuTransferService;


    public void testXX() {
        int pageNum = 1;
        int pageSize = 10000;
        Integer lastId = null;
        for (; ; ) {
            IPage<DcBaseOmsSku> page = new Page<>(pageNum, pageSize);

            LambdaQueryWrapper<DcBaseOmsSku> wrapper = new LambdaQueryWrapper<>();
            if (lastId != null) {
                wrapper.gt(DcBaseOmsSku::getId, lastId);
            }
            dcBaseOmsSkuService.page(page);
            if (ListUtil.isEmpty(page.getRecords())) {
                break;
            }
            List<DcBaseOmsSkuTransfer> dcBaseOmsSkuTransferList = page.getRecords()
                    .stream()
                    .map(dcBaseOmsSku -> {
                        DcBaseOmsSkuTransfer dcBaseOmsSkuTransfer = new DcBaseOmsSkuTransfer();
                        BeanUtils.copyProperties(dcBaseOmsSku, dcBaseOmsSkuTransfer);
                        return dcBaseOmsSkuTransfer;
                    })
                    .collect(Collectors.toList());
            dcBaseOmsSkuTransferService.saveBatch(dcBaseOmsSkuTransferList);
            lastId = page.getRecords().get(page.getRecords().size() - 1).getId();
        }

    }

//    @Transactional
    public void syncOmsSku30() {
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(baseSyncOmsSku30);
        int pageNum = dcJobConfig.getPageNum();
        int pageSize = dcJobConfig.getPageSize();
        for (; ; ) {
            IPage<DcBaseOmsSku> pageParam = new Page<>(pageNum, pageSize);
            LambdaQueryWrapper<DcBaseOmsSku> wrapper = new LambdaQueryWrapper<DcBaseOmsSku>()
                    .between(DcBaseOmsSku::getGmtModified, dcJobConfig.getStartTime().minusMinutes(3), dcJobConfig.getEndTime());

            IPage<DcBaseOmsSku> page = dcBaseOmsSkuMapper.selectPage(pageParam, wrapper);
            if (ListUtil.isEmpty(page.getRecords())) {
                break;
            }
            page.getRecords().parallelStream().forEach(dcBaseOmsSku -> {
                DcBaseOmsSku30 dcBaseOmsSku30 = new DcBaseOmsSku30();
                BeanUtils.copyProperties(dcBaseOmsSku, dcBaseOmsSku30, "id");
                dcBaseOmsSku30.setSku30Modify(LocalDateTime.now());

                LambdaQueryWrapper<DcBaseOmsSku30> wrapper1 = new LambdaQueryWrapper<>();
                wrapper1.eq(DcBaseOmsSku30::getBailunSku, dcBaseOmsSku30.getBailunSku())
                        .eq(DcBaseOmsSku30::getOriginOrderId, dcBaseOmsSku30.getOriginOrderId())
                        .eq(DcBaseOmsSku30::getBailunAccountId, dcBaseOmsSku30.getBailunAccountId());

                dcBaseOmsSku30Service.saveOrUpdate(dcBaseOmsSku30, wrapper1);
                log.info("同步一条oms-sku-30 {}", dcBaseOmsSku30.getBailunSku());
            });


            pageNum++;
            dcJobConfig.setPageNum(pageNum);
            dcJobConfigMapper.updateById(dcJobConfig);
        }

        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }

    @Transactional
    public void syncOmsSku302() {
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(baseSyncOmsSku302);
        int pageNum = 1;
        int pageSize = 1000;
        for (; ; ) {
            IPage<DcBaseOmsSku> pageParam = new Page<>(pageNum, pageSize);
            LambdaQueryWrapper<DcBaseOmsSku> wrapper = new LambdaQueryWrapper<DcBaseOmsSku>()
                    .between(DcBaseOmsSku::getOrderUpdateTime, dcJobConfig.getStartTime(), dcJobConfig.getEndTime());

            IPage<DcBaseOmsSku> page = dcBaseOmsSkuMapper.selectPage(pageParam, wrapper);
            if (ListUtil.isEmpty(page.getRecords())) {
                break;
            }
            page.getRecords().parallelStream().forEach(dcBaseOmsSku -> {
                DcBaseOmsSku30 dcBaseOmsSku30 = new DcBaseOmsSku30();
                BeanUtils.copyProperties(dcBaseOmsSku, dcBaseOmsSku30, "id");
                dcBaseOmsSku30.setSku30Modify(LocalDateTime.now());

                LambdaQueryWrapper<DcBaseOmsSku30> wrapper1 = new LambdaQueryWrapper<>();
                wrapper1.eq(DcBaseOmsSku30::getBailunSku, dcBaseOmsSku30.getBailunSku())
                        .eq(DcBaseOmsSku30::getOriginOrderId, dcBaseOmsSku30.getOriginOrderId())
                        .eq(DcBaseOmsSku30::getBailunAccountId, dcBaseOmsSku30.getBailunAccountId());

                dcBaseOmsSku30Service.saveOrUpdate(dcBaseOmsSku30, wrapper1);
                log.info("同步一条oms-sku-30 {}", dcBaseOmsSku30.getBailunSku());
            });


            pageNum++;
        }
        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }
}
