package com.bailuntec.job.service;

import com.bailuntec.application.IDcBaseFinanceManagecostService;
import com.bailuntec.common.BeanUtils;
import com.bailuntec.common.ListUtil;
import com.bailuntec.cost.api.CostApi;
import com.bailuntec.cost.api.dto.CostDto;
import com.bailuntec.cost.api.dto.ManageCostDto;
import com.bailuntec.cost.api.request.ManageCostListReq;
import com.bailuntec.cost.api.response.CostResult;
import com.bailuntec.domain.DcBaseFinanceFee;
import com.bailuntec.domain.DcBaseFinanceManagecost;
import com.bailuntec.domain.DcJobConfig;
import com.bailuntec.infrastructure.mapper.DcBaseFinanceFeeMapper;
import com.bailuntec.infrastructure.mapper.DcBaseFinanceLogisticsMapper;
import com.bailuntec.infrastructure.mapper.DcBaseFinanceManagecostMapper;
import com.bailuntec.infrastructure.mapper.DcJobConfigMapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/7 11:38 上午
 */
@Slf4j
@Service
public class SyncFeeService {

    public static final String baseSyncFinanceFee = "base-sync-finance-fee";
    public static final String baseSyncLogistics = "base-sync-logistics";
    public static final String baseSyncManageCost = "base-sync-manage-cost";
    public static final String baseSyncDailyFee = "base-sync-daily-fee";

    @Resource
    DcJobConfigMapper dcJobConfigMapper;
    @Resource
    DcBaseFinanceFeeMapper dcBaseFinanceFeeMapper;
    @Resource
    DcBaseFinanceLogisticsMapper dcBaseFinanceLogisticsMapper;
    @Resource
    CostApi costApi;
    @Resource
    DcBaseFinanceManagecostMapper dcBaseFinanceManagecostMapper;
    @Resource
    IDcBaseFinanceManagecostService dcBaseFinanceManagecostService;


    @Transactional
    public void syncFinanceFee() {
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(baseSyncFinanceFee);
        Integer pageNum = 1;
        Integer pageSize = 100;
        for (; ; ) {

            CostResult<List<CostDto>> result = costApi.getCostList(dcJobConfig.getStartTimeStr(),
                    dcJobConfig.getEndTimeStr(),
                    pageNum,
                    pageSize);

            if (ListUtil.isEmpty(result.getData())) {
                break;
            }
            result.getData().forEach(costDto -> {
                DcBaseFinanceFee dcBaseFinanceFee = new DcBaseFinanceFee();
                BeanUtils.copyProperties(costDto, dcBaseFinanceFee);

                dcBaseFinanceFee.setCreateTime(LocalDateTime.ofInstant(costDto.getCreateTime().toInstant(), ZoneId.systemDefault()));
                if (costDto.getPayTime() != null) {
                    dcBaseFinanceFee.setPayTime(LocalDateTime.ofInstant(costDto.getPayTime().toInstant(), ZoneId.systemDefault()));
                }
                if (costDto.getAuditTime() != null) {
                    dcBaseFinanceFee.setAuditTime(LocalDateTime.ofInstant(costDto.getAuditTime().toInstant(), ZoneId.systemDefault()));
                }
                dcBaseFinanceFee.setBjModified(LocalDateTime.now());
                //更新
                int update = dcBaseFinanceFeeMapper.update(dcBaseFinanceFee, new LambdaQueryWrapper<DcBaseFinanceFee>()
                        .eq(DcBaseFinanceFee::getCostNo, dcBaseFinanceFee.getCostNo()));
                //插入
                if (update == 0) {
                    dcBaseFinanceFee.setBjCreate(LocalDateTime.now());
                    dcBaseFinanceFeeMapper.insert(dcBaseFinanceFee);
                }
                log.info("同步一条费用单,costNo:{}", costDto.getCostNo());
            });

            pageNum++;
        }

        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }


    @Transactional
    public void syncManageCost() {
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(baseSyncManageCost);

        ManageCostListReq req = new ManageCostListReq();

        req.setStartDateStr(dcJobConfig.getStartTimeStr());
        req.setEndDateStr(dcJobConfig.getEndTimeStr());

        CostResult<List<ManageCostDto>> result = costApi.manageCostList(req);

        //同步
        result.getData().forEach(manageCostDto -> {

            DcBaseFinanceManagecost dcBaseFinanceManagecost = dcBaseFinanceManagecostMapper.selectOne(new LambdaQueryWrapper<DcBaseFinanceManagecost>()
                    .eq(DcBaseFinanceManagecost::getNo, manageCostDto.getNo()));
            if (dcBaseFinanceManagecost == null) {
                dcBaseFinanceManagecost = new DcBaseFinanceManagecost();
                dcBaseFinanceManagecost.setGmtCreateTime(LocalDateTime.now());
            }
            BeanUtils.copyProperties(manageCostDto, dcBaseFinanceManagecost, "id");
            dcBaseFinanceManagecost.setGmtModifyTime(LocalDateTime.now());
            dcBaseFinanceManagecost.setPayTime(manageCostDto.getPayTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
            dcBaseFinanceManagecostService.saveOrUpdate(dcBaseFinanceManagecost);
            log.info("同步一条管理成本,costNo:{}", manageCostDto.getCostId());

        });

        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }

    @Transactional
    public void syncDailyFee() {
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(baseSyncDailyFee);
        LocalDate date = dcJobConfig.getStartTime().toLocalDate();
        dcBaseFinanceFeeMapper.deleteDailyFee(date);
        dcBaseFinanceFeeMapper.insertDailyFee(date);

        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }


}
