package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 在途数据每日表
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcDailyTransitFrom对象", description="在途数据每日表")
public class DcDailyTransitFrom implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "数据中心创建时间")
    private LocalDateTime gmtCreate;

    @ApiModelProperty(value = "数据中心更新时间")
    private LocalDateTime gmtModified;

    @ApiModelProperty(value = "SKU")
    private String bailunSku;

    @ApiModelProperty(value = "目的仓库编码/调入仓库")
    private String warehouseCode;

    @ApiModelProperty(value = "目的仓中文名称")
    private String warehouseName;

    @ApiModelProperty(value = "起始仓编码/调出仓库")
    private String sourceWarehouseCode;

    @ApiModelProperty(value = "起始仓中文名称")
    private String sourceWarehouseName;

    @ApiModelProperty(value = "30天内调拨数，调出，交运数据")
    private Integer quantityTransferDelivery;

    @ApiModelProperty(value = "30天内调拨数，调入")
    private Integer quantityTransferInbound;

    @ApiModelProperty(value = "调拨在途数量(不包含调拨计划)")
    private Integer quantityTransfer;

    @ApiModelProperty(value = "调拨计划在途数量")
    private Integer quantityTransferPlan;

    @ApiModelProperty(value = "数据中心记录时间")
    private LocalDate recordTime;

    @ApiModelProperty(value = "公司Id,0和1是百伦")
    private Integer companyId;

    @ApiModelProperty(value = "SKUMS当天的单价")
    private BigDecimal unitPrice;


}
