package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "DcBaseFinanceManagecost对象", description = "")
public class DcBaseFinanceManagecost implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "费用单号")
    private String no;

    @ApiModelProperty(value = "收款/付款单位")
    private String receiveUnit;

    @ApiModelProperty(value = "付款理由")
    private String reason;

    @ApiModelProperty(value = "支付时间")
    private LocalDateTime payTime;

    @ApiModelProperty(value = "费用类 -1耗材 1付款  2收款  3借支/借还")
    private Integer manageCostType;

    @ApiModelProperty(value = "部门")
    private String departmentName;

    @ApiModelProperty(value = "公司主体value")
    private Integer companyValue;

    @ApiModelProperty(value = "主体名称")
    private String companyName;

    @ApiModelProperty(value = "会计科目")
    private String accountingSubjectName;

    @ApiModelProperty(value = "原管理成本表分类名")
    private String feeSuperType;

    @ApiModelProperty(value = "费用小类")
    private String feeSubType;

    @ApiModelProperty(value = "金额(原币)")
    private BigDecimal amount;

    @ApiModelProperty(value = "币种")
    private String currency;

    @ApiModelProperty(value = "金额(人民币)")
    private BigDecimal amountRmb;

    private Integer costId1;

    private Integer costId;

    @ApiModelProperty(value = "数据中心创建时间")
    private LocalDateTime gmtCreateTime;

    @ApiModelProperty(value = "数据中心更新时间")
    private LocalDateTime gmtModifyTime;


}
