package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseFinanceCashierdetail对象", description="")
public class DcBaseFinanceCashierdetail implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "唯一id")
    private Integer cwId;

    @ApiModelProperty(value = "数据类型")
    private Integer dataType;

    @ApiModelProperty(value = "提现起始帐号")
    private String fromAccount;

    @ApiModelProperty(value = "提现起始币种id")
    private Integer fromCurrency;

    @ApiModelProperty(value = "转换币种(中间币种)")
    private String exchangeCurrency;

    @ApiModelProperty(value = "转换金额(中间金额)")
    private BigDecimal exchangeMoney;

    @ApiModelProperty(value = "目标帐号")
    private String toAccount;

    @ApiModelProperty(value = "目标币种id")
    private Integer toCurrency;

    @ApiModelProperty(value = "起始金额(原币种金额)")
    private BigDecimal money;

    @ApiModelProperty(value = "服务费")
    private BigDecimal serviceCharge;

    @ApiModelProperty(value = "到账时间")
    private LocalDateTime daozhangTime;

    @ApiModelProperty(value = "到账金额(原始币种金额)")
    private BigDecimal daozhangMoney;

    @ApiModelProperty(value = "确认用户")
    private String confirmName;

    @ApiModelProperty(value = "状态：1#未到账 2#已到账")
    private Integer status;

    @ApiModelProperty(value = "创建用户")
    private String createName;

    @ApiModelProperty(value = "创建时间")
    @TableField("createTime")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "修改用户")
    private String updateName;

    @ApiModelProperty(value = "修改时间")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "起始币种名称")
    private String fromCurrencyName;

    @ApiModelProperty(value = "目标币种名称")
    private String toCurrencyName;

    @ApiModelProperty(value = "采集平台")
    private Integer collectionPlatform;

    @ApiModelProperty(value = "银行")
    private String bank;

    @ApiModelProperty(value = "销售平台")
    private Integer saleslPlatform;

    @ApiModelProperty(value = "销售帐号")
    private String salesAccount;

    @ApiModelProperty(value = "转人民币汇率")
    private BigDecimal otherToCnyExchangeRate;

    @ApiModelProperty(value = "转人民币金额")
    private BigDecimal otherToCnyMoney;

    @ApiModelProperty(value = "数据中心创建时间")
    private LocalDateTime gmtCreateTime;

    @ApiModelProperty(value = "数据中心修改时间")
    private LocalDateTime gmtModifyTime;


}
