package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 自动周转矫正曲线参数设置
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcAutoConfigCorrection对象", description="自动周转矫正曲线参数设置")
public class DcAutoConfigCorrection implements Serializable {

    private static final long serialVersionUID = 1L;

    private LocalDateTime gmtCreate;

    private LocalDateTime gmtModified;

    private String bailunSku;

    @ApiModelProperty(value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(value = "增益因子, 限制大于0")
    private BigDecimal param;

    @ApiModelProperty(value = "yyyy-M-dd 开始时间,若只配置单个当天时间, 放在在这里")
    private LocalDate startTime;

    @ApiModelProperty(value = "yyyy-M-dd 结束时间")
    private LocalDate endTime;

    @ApiModelProperty(value = "操作员")
    private String blOperator;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    private String remark;


}
