package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in 17:02 2021-03-27
 * @Modified by:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "DcSemiSupplierOfferLog对象", description = "")
public class DcSemiSupplierOfferLog implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    @ApiModelProperty("id")
    private Integer id;

    @ApiModelProperty("流水ID")
    private Integer logId;

    @ApiModelProperty("供应商ID")
    private Integer supplierId;

    @ApiModelProperty("供应商名称")
    private String supplierName;

    @ApiModelProperty("币种ID")
    private Integer unitId;

    @ApiModelProperty("币种名称")
    private String unitName;

    @ApiModelProperty("半成品系统创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("报价")
    private BigDecimal price;

    @ApiModelProperty("原料SKU编码")
    private String skuCode;

    @ApiModelProperty("原料SKU名称")
    private String skuName;

    @ApiModelProperty("原料SKU ID")
    private Integer skuId;

    @ApiModelProperty("取数时间")
    private LocalDateTime updateTime;
}
