package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 百伦头程费信息, 到物流单维度, 取的平均
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcMidCostFirstOrder对象", description="百伦头程费信息, 到物流单维度, 取的平均")
public class DcMidCostFirstOrder implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "SKU头程费_RMB")
    private BigDecimal costFirst;

    @ApiModelProperty(value = "百伦SKU")
    private String bailunSku;

    @ApiModelProperty(value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(value = "物流单号")
    private String channelOrderId;

    @ApiModelProperty(value = "SKU重量占比")
    private BigDecimal weightRatio;

    @ApiModelProperty(value = "物流单中这个SKU的数量")
    private Integer quantity;

    @ApiModelProperty(value = "调拨单号")
    private String transferOrderId;

    @ApiModelProperty(value = "公司Id,0和1是百伦")
    private Integer companyId;

    @ApiModelProperty(value = "是否计算 0 否 1 计算")
    private Boolean hasCalculation;

    @ApiModelProperty(value = "箱号")
    private String boxId;


}
