# 新数据中心java同步服务
新数据中心同步服务

## 一、如何使用

### 1.1 项目架构
k8s集群: bailun/data-center-job  
datacenter-task: spring-cloud-data-flow + spring batch  
datacenter-job:  spring schedule  
datacenter-domain: 领域模块  


### 1.2 主要三方库
- springboot 
- mybatis
- mybatis plus 

### 1.3 部署环境
- 子账号k8s集群 bailun/data-center-job deployment名称同镜像名称
- 镜像名称见pom.xml 
- scdf地址http://dataflow.bailuntec.com/dashboard/index.html 只迁移了两个 使用见springcloud data flow官方文档。
- scdf 部署在k8s集群 命名空间 /default/service/scdf-server, /default/ingress/datacenter-scdf,/default/secret/scdf-sa-token-qgtsp
, /default/configMap/scdf-server.. ,
```xml
<imageName>ccr.ccs.tencentyun.com/blt.data.job/ebay-report-produce:latest</imageName>
```
 
## 二、项目结构
```
├── README.md
├── datacenter-domain //实体 方法
├── datacenter-job
│   ├── datacenter-base
│   │   ├── base-sync-cashier           //同步财务信息
│   │   ├── base-sync-company           //同步公司和账户信息
│   │   ├── base-sync-ebay              //同步EBAY费用信息
│   │   ├── base-sync-fee               //同步费用系统信息 
│   │   ├── base-sync-purchase-details  //同步采购系统详情
│   │   ├── base-sync-sample            //示例代码
│   │   ├── base-sync-sku               //同步SKUMS
│   ├── datacenter-finance
│   │   ├── finance-balance-sheet       //资产负债表
│   ├── datacenter-mid
│   │   ├── mid-calculate-transit       //计算在途,缺货等数据
│   │   ├── mid-calculate-turnover-prepare //周转预计算
│   │   ├── mid-daily-snapshot          //每日快照数据
├── datacenter-task
│   ├── ebay-report-consumer            //scdf ebay  报告下载分析写入
│   ├── ebay-report-produce             //scdf edbay 报告生成


```
## 三、如何开发
略
