package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 公司主体短期借款表
 * </p>
 *
 * @author robbendev
 * @since 2020-11-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcShortTermBorrow对象", description="公司主体短期借款表")
public class DcShortTermBorrow implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "借款公司主体Value")
    private Integer companyValue;

    @ApiModelProperty(value = "借入公司主体名称")
    private String companyName;

    @ApiModelProperty(value = "借款账户")
    private String bankCard;

    @ApiModelProperty(value = "借款银行")
    private String bankName;

    @ApiModelProperty(value = "借款银行持卡人")
    private String bankCardUser;

    @ApiModelProperty(value = "债权方")
    private String creditor;

    @ApiModelProperty(value = "借款余额,RMB(未还款人民币金额)")
    private BigDecimal balanceRmb;

    @ApiModelProperty(value = "统计时间")
    private LocalDate statisticalTime;

    @ApiModelProperty(value = "取数时间")
    private LocalDateTime updateTime;


}
