package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 库龄
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcMidStockDate对象", description="库龄")
public class DcMidStockDate implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "数据中心创建时间")
    private LocalDateTime gmtCreate;

    @ApiModelProperty(value = "数据中心修改时间")
    private LocalDateTime gmtModified;

    @ApiModelProperty(value = "百伦sku")
    private String bailunSku;

    @ApiModelProperty(value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(value = "库存数量")
    private Integer quantityStock;

    @ApiModelProperty(value = "库存时间")
    private LocalDateTime stockTime;

    @ApiModelProperty(value = "采购单价")
    private BigDecimal unitPrice;

    @ApiModelProperty(value = "同步库存表初始值")
    private Integer initStock;

    @ApiModelProperty(value = "是否有初始值")
    private Boolean hasInit;

    @ApiModelProperty(value = "0：采购 ，1：调拨")
    private Integer hasTransfer;

    @ApiModelProperty(value = "无")
    private LocalDateTime reportDate;


}
