package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 在途数据每日表
 * </p>
 *
 * @author robbendev
 * @since 2020-12-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcDailyTransit对象", description="在途数据每日表")
public class DcDailyTransit implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "数据中心创建时间")
    private LocalDateTime gmtCreate;

    @ApiModelProperty(value = "数据中心更新时间")
    private LocalDateTime gmtModified;

    @ApiModelProperty(value = "SKU")
    private String bailunSku;

    @ApiModelProperty(value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(value = "采购在途数量")
    private Integer quantityPurchase;

    @ApiModelProperty(value = "生产采购在途数量")
    private Integer quantityPurchasePro;

    @ApiModelProperty(value = "调拨在途数量")
    private Integer quantityTransfer;

    @ApiModelProperty(value = "调拨计划在途数量")
    private Integer quantityTransferPlan;

    @ApiModelProperty(value = "数据中心记录时间")
    private LocalDate recordTime;

    @ApiModelProperty(value = "公司Id,0和1是百伦")
    private Integer companyId;

    @ApiModelProperty(value = "SKUMS当天的单价")
    private BigDecimal unitPrice;


}
