package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * FBA共享库存但是没有优先级配置的平台SKU
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseStockConfigFbaLose对象", description="FBA共享库存但是没有优先级配置的平台SKU")
public class DcBaseStockConfigFbaLose implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "平台SKU,这个平台SKU有共享库存,但是没在dc_base_stock_config_fba配置优先级仓库")
    private String platformSku;

    @ApiModelProperty(value = "数据中心-创建时间")
    private LocalDateTime gmtCreate;

    @ApiModelProperty(value = "数据中心-更新时间")
    private LocalDateTime gmtModified;

    @ApiModelProperty(value = "公司Id,0和1是百伦")
    private Integer companyId;


}
