package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 采购单详细信息表
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBasePurchaseDetails对象", description="采购单详细信息表")
public class DcBasePurchaseDetails implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "采购单号")
    private String purchaseId;

    @ApiModelProperty(value = "状态-1：作废，0：待确认，1：已确认 4：已完成")
    private Integer status;

    @ApiModelProperty(value = "采购类型")
    private String purchaseCategoryName;

    @ApiModelProperty(value = "采购系统的供应商ID")
    private Integer deliverId;

    @ApiModelProperty(value = "采购系统的供应商名称")
    private String deliverName;

    @ApiModelProperty(value = "供应商value值")
    private Integer deliverValue;

    @ApiModelProperty(value = "采购员名称")
    private String buyerName;

    @ApiModelProperty(value = "采购仓库编码")
    private String warehouseFromCode;

    @ApiModelProperty(value = "采购仓库名称")
    private String warehouseFromName;

    @ApiModelProperty(value = "目的仓库编码")
    private String warehouseIntoCode;

    @ApiModelProperty(value = "目的仓库名称")
    private String warehouseIntoName;

    private String bailunSku;

    @ApiModelProperty(value = "采购数量")
    private Integer quantityPurchase;

    @ApiModelProperty(value = "采购单价")
    private BigDecimal unitPrice;

    @ApiModelProperty(value = "采购总价")
    private BigDecimal amountPaid;

    @ApiModelProperty(value = "币种编码")
    private String currencyCode;

    @ApiModelProperty(value = "币种名称")
    private String currencyName;

    @ApiModelProperty(value = "退货数量")
    private Integer quantityReturn;

    @ApiModelProperty(value = "入库数量")
    private Integer quantityInbound;

    @ApiModelProperty(value = "发货数量")
    private Integer quantityDeliver;

    @ApiModelProperty(value = "未发货数量")
    private Integer quantityNotDeliver;

    @ApiModelProperty(value = "到货数量")
    private Integer quantityArrival;

    @ApiModelProperty(value = "未到货数量")
    private Integer quantityNotArrival;

    @ApiModelProperty(value = "质检数量")
    private Integer quantityInspect;

    @ApiModelProperty(value = "质检合格数量")
    private Integer quantityQualifiedInspect;

    @ApiModelProperty(value = "质检不合格数量")
    private Integer quantityUnqualifiedInspect;

    @ApiModelProperty(value = "待调拨数量")
    private Integer quantityWaitTransfer;

    @ApiModelProperty(value = "换货数量")
    private Integer quantityExchange;

    @ApiModelProperty(value = "入库丢失数量")
    private Integer quantityLoseInbound;

    @ApiModelProperty(value = "采购系统创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "采购系统更新时间")
    private LocalDateTime updateTime;

    private LocalDateTime gmtCreate;

    private LocalDateTime gmtModified;

    @ApiModelProperty(value = "未入库数量")
    private Integer quantityNotInbound;

    @ApiModelProperty(value = "阿里巴巴单号")
    private String alibabaOrderId;

    @ApiModelProperty(value = "物流单号")
    private String logisticsOrderId;

    @ApiModelProperty(value = "物流公司")
    private String logisticsCompanyName;

    @ApiModelProperty(value = "公司Id,0和1是百伦")
    private Integer companyId;

    @ApiModelProperty(value = "0：无需推送，1：未推送，2：推送成功，3：推送失败")
    private Integer ispush;

    @ApiModelProperty(value = "1：调拨，0：非调拨")
    private Integer isallot;

    private Integer isaims;

    @ApiModelProperty(value = "付款方式 1先款后货，2先货后款，3无需付款")
    private Integer payType;

    @ApiModelProperty(value = "付款状态  0：未付款，1：部分付款，2：已付款，3无需付款")
    private Integer payStatus;

    @ApiModelProperty(value = "最后签收时间")
    private LocalDateTime lastSigntime;

    @ApiModelProperty(value = "到货状态  0：未到货，1：部分到货，2：全部到货，3：部分到货不等待剩余")
    private Integer arrivalStatus;

    @ApiModelProperty(value = "采购单采购总金额")
    private BigDecimal amountBuy;

    @ApiModelProperty(value = "采购单已付款总金额")
    private BigDecimal amountPayed;

    @ApiModelProperty(value = "采购单快递费")
    private BigDecimal amountExpress;

    @ApiModelProperty(value = "创建人")
    private String createusername;


}
