package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseFinanceWish对象", description="")
public class DcBaseFinanceWish implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "广告系列id")
    private String campaignId;

    @ApiModelProperty(value = "广告系列的名称")
    private String campaignName;

    @ApiModelProperty(value = "其他转人民币汇率")
    private BigDecimal otherToCnyExchangeRate;

    private BigDecimal otherToUsdExchangeRate;

    @ApiModelProperty(value = "广告系列预算")
    private BigDecimal campaignMaxBudget;

    @ApiModelProperty(value = "为true表示是一个自动广告系列")
    private Boolean isAutomatedCampaign;

    @ApiModelProperty(value = "为true则广告系列结束后自动续订")
    private Boolean autoRenew;

    @ApiModelProperty(value = "预算金额")
    private BigDecimal scheduledAddBudgetAmount;

    @ApiModelProperty(value = "总展示次数")
    private Integer totalImpressions;

    @ApiModelProperty(value = "开始时间")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "总销售量")
    private Integer sales;

    @ApiModelProperty(value = "付费展示的总费用")
    private BigDecimal totalImpressionFeesCharged;

    @ApiModelProperty(value = "为true表示预算会定期自动添加到此广告系列")
    private Boolean scheduledAddBudgetEnabled;

    private String merchantId;

    @ApiModelProperty(value = "印象费用细分")
    private String impressionFeesBreakdown;

    @ApiModelProperty(value = "广告状态")
    private String campaignState;

    @ApiModelProperty(value = "是否可编辑")
    private Boolean canEdit;

    @ApiModelProperty(value = "0-1之间的比率代表折扣")
    private BigDecimal discountRatio;

    @ApiModelProperty(value = "为true表示此广告系列是Simple Boost广告系列")
    private Boolean isSimpleBoost;

    @ApiModelProperty(value = "此广告系列的总费用 美元")
    private BigDecimal totalCampaignSpend;

    @ApiModelProperty(value = "0-6，表示星期几的预算会自动添加到此广告系列中")
    private String scheduledAddBudgetDays;

    @ApiModelProperty(value = "广告系列的最后更新时间")
    private LocalDateTime lastUpdatedTime;

    @ApiModelProperty(value = "结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "注册费用")
    private BigDecimal totalEnrollmentFeesCharged;

    @ApiModelProperty(value = "总gmv")
    private BigDecimal gmv;

    private Integer accountId;

    private Integer companyId;

    private LocalDateTime gmtCreateTime;

    private LocalDateTime gmtModifyTime;

    @ApiModelProperty(value = "数据中心统计时间")
    private LocalDate recordTime;

    private BigDecimal dailyCampaignMaxBudget;

    private BigDecimal dailyTotalCampaignSpend;

    private BigDecimal dailyGmv;


}
