package com.bailuntec.job.service;

import com.bailuntec.application.IDcBaseStockService;
import com.bailuntec.common.ListUtil;
import com.bailuntec.domain.DcBaseStock;
import com.bailuntec.domain.DcJobConfig;
import com.bailuntec.infrastructure.mapper.DcBaseStockMapper;
import com.bailuntec.infrastructure.mapper.DcJobConfigMapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/7 11:38 上午
 */
@Service
public class TurnoverPrepareService {

    @Resource
    DcJobConfigMapper dcJobConfigMapper;

    private static final String midSupplyOrderSku = "mid-supply-order-sku";
    private static final String midSupplyPurchaseSku = "mid-supply-purchase-sku";
    private static final String midSupplyTransitSku = "mid-supply-transit-sku";

    @Resource
    private DcBaseStockMapper dcBaseStockMapper;
    @Resource
    private IDcBaseStockService dcBaseStockService;

    public void supplyOrderSku() {
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(midSupplyOrderSku);
        int pageNum = dcJobConfig.getPageNum();
        int pageSize = dcJobConfig.getPageSize();

        for (; ; ) {
            List<DcBaseStock> dcBaseStockList = dcBaseStockMapper.selectSupplyOrderSku((pageNum - 1) * pageSize, pageSize);
            if (ListUtil.isEmpty(dcBaseStockList)) {
                break;
            }
            dcBaseStockService.saveBatch(dcBaseStockList);
            pageNum++;

            dcJobConfig.setPageNum(pageNum);
            dcJobConfigMapper.updateById(dcJobConfig);
        }
        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }

    public void supplyPurchaseSku() {
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(midSupplyPurchaseSku);
        int pageNum = dcJobConfig.getPageNum();
        int pageSize = dcJobConfig.getPageSize();

        for (; ; ) {
            List<DcBaseStock> dcBaseStockList = dcBaseStockMapper.selectSupplyPurchaseSku((pageNum - 1) * pageSize, pageSize);
            if (ListUtil.isEmpty(dcBaseStockList)) {
                break;
            }
            dcBaseStockService.saveBatch(dcBaseStockList);
            pageNum++;
            dcJobConfig.setPageNum(pageNum);
            dcJobConfigMapper.updateById(dcJobConfig);
        }

        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }


    public void supplyTransitSku() {
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(midSupplyTransitSku);
        int pageNum = dcJobConfig.getPageNum();
        int pageSize = dcJobConfig.getPageSize();

        for (; ; ) {
            List<DcBaseStock> dcBaseStockList = dcBaseStockMapper.selectSupplyTransitSku((pageNum - 1) * pageSize, pageSize);
            if (ListUtil.isEmpty(dcBaseStockList)) {
                break;
            }
            dcBaseStockService.saveBatch(dcBaseStockList);
            pageNum++;
            dcJobConfig.setPageNum(pageNum);
            dcJobConfigMapper.updateById(dcJobConfig);
        }
        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }
}
