package com.bailuntec.job;

import com.bailuntec.api.bailuntec.oa.OaApi;
import com.bailuntec.application.IDcBaseFinanceEbayService;
import com.bailuntec.domain.DcBaseFinanceEbay;
import com.bailuntec.domain.DcJobConfig;
import com.bailuntec.infrastructure.mapper.DcBaseCompanyAccountMapper;
import com.bailuntec.infrastructure.mapper.DcJobConfigMapper;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/1/19 1:37 下午
 */
@Configuration
@EnableBatchProcessing
public class JobConfiguration {

    public final JobBuilderFactory jobBuilderFactory;
    public final StepBuilderFactory stepBuilderFactory;
    private final DcBaseCompanyAccountMapper dcBaseCompanyAccountMapper;
    private final IDcBaseFinanceEbayService dcBaseFinanceEbayService;
    private final OaApi oaApi;

    private DcJobConfig dcJobConfig;

    @Autowired
    EbayJobListener ebayJobListener;


    @Autowired
    public JobConfiguration(JobBuilderFactory jobBuilderFactory,
                            StepBuilderFactory stepBuilderFactory,
                            DcBaseCompanyAccountMapper dcBaseCompanyAccountMapper,
                            DcJobConfigMapper dcJobConfigMapper,
                            IDcBaseFinanceEbayService dcBaseFinanceEbayService,
                            OaApi oaApi) {
        this.jobBuilderFactory = jobBuilderFactory;
        this.stepBuilderFactory = stepBuilderFactory;
        this.dcBaseCompanyAccountMapper = dcBaseCompanyAccountMapper;
        this.dcBaseFinanceEbayService = dcBaseFinanceEbayService;
        this.oaApi = oaApi;
        dcJobConfig = dcJobConfigMapper.selectByName("base-sync-finance-ebay-ad");
    }

    @Bean
    EbayItemReader reader() {
        return new EbayItemReader(dcBaseCompanyAccountMapper, dcJobConfig,
                dcBaseFinanceEbayService);
    }

    @Bean
    EbayItemProcessor processor() {
        return new EbayItemProcessor(dcJobConfig, oaApi);
    }

    @Bean
    EbayFinanceWriter writer() {
        return new EbayFinanceWriter(dcBaseFinanceEbayService);
    }

    @Bean
    public Job dataHandleJob() {
        return jobBuilderFactory.get("dataHandleJob")
                .incrementer(new RunIdIncrementer())
                .start(handleDataStep())   //start是JOB执行的第一个step
//                ...
                .build();
    }

    @Bean
    public Step handleDataStep() {
        return stepBuilderFactory.get("getData")
                .<EbayItem, DcBaseFinanceEbay>chunk(100)        // <输入,输出> 。chunk通俗的讲类似于SQL的commit; 这里表示处理(processor)100条后写入(writer)一次。
                .reader(reader())         //指定ItemReader
                .processor(processor())   //指定ItemProcessor
                .writer(writer())//指定ItemWriter
                .listener(ebayJobListener)
                .build();
    }

    public void setDcJobConfig(DcJobConfig dcJobConfig) {
        this.dcJobConfig = dcJobConfig;
    }

    public DcJobConfig getDcJobConfig() {
        return dcJobConfig;
    }


}
