package com.bailuntec.job;

import com.bailuntec.domain.DcJobConfig;
import com.bailuntec.infrastructure.mapper.DcJobConfigMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/1/20 9:58 上午
 */
@Slf4j
@Component
public class EbayJobListener extends JobExecutionListenerSupport {

    private final DcJobConfigMapper dcJobConfigMapper;
    private final JobConfiguration jobConfiguration;

    public EbayJobListener(DcJobConfigMapper dcJobConfigMapper,
                           JobConfiguration jobConfiguration) {
        super();
        this.dcJobConfigMapper = dcJobConfigMapper;
        this.jobConfiguration = jobConfiguration;
    }

    @Override
    public void afterJob(JobExecution jobExecution) {

        DcJobConfig dcJobConfig = jobConfiguration.getDcJobConfig();

        if (jobExecution.getStatus() == BatchStatus.COMPLETED) {
            log.info("!!! JOB FINISHED! Time to verify the results");

        }
        if (jobExecution.getStatus() == BatchStatus.FAILED) {
            //todo 任务失败提醒推送
            log.error("!!! JOB FAILED");
        }

        dcJobConfigMapper.updateById(dcJobConfig.refresh());

    }

    @Override
    public void beforeJob(JobExecution jobExecution) {

    }
}
