package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 线上sku刊登资料 每小时刷新
 * </p>
 *
 * @author robbendev
 * @since 2020-12-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "DcBaseSkuMappingOnline对象", description = "线上sku刊登资料 每小时刷新")
public class DcBaseSkuMappingOnline implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final Map<Integer, String> platformMap = new HashMap<>();

    static {
        platformMap.put(0, "Amazon");
        platformMap.put(1, "Ebay");
        platformMap.put(2, "Wish");
        platformMap.put(3, "Walmart");
        platformMap.put(4, "Aliexpress");
        platformMap.put(5, "Coupang");
        platformMap.put(6, "Lazada");
        platformMap.put(7, "Shopee");
    }

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    private String itemId;

    private String skuCode;

    private String itemSku;

    private Boolean isDeleted;

    private Integer platform;

    private String platformStr;

    private String site;

    private Integer accountId;

    private String accountName;

    private LocalDateTime gmtCreate;

    private LocalDateTime gmtModified;


}
