package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 资产负债表,RMB
 * </p>
 *
 * @author robbendev
 * @since 2020-11-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "DcBalanceSheet对象", description = "资产负债表,RMB")
public class DcBalanceSheet implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "公司主体value")
    private Integer companyValue;

    @ApiModelProperty(value = "公司名称")
    private String companyName;

    @ApiModelProperty(value = "货币资金")
    private BigDecimal monetaryFund;

    @ApiModelProperty(value = "银行账号余额")
    private BigDecimal bankAccountBalance;

    @ApiModelProperty(value = "提现在途金额")
    private BigDecimal withdrawAmount;

    @ApiModelProperty(value = "第三方平台余额")
    private BigDecimal platformBalance;

    @ApiModelProperty(value = "应收账款")
    private BigDecimal accountsReceivable;

    @ApiModelProperty(value = "借支金额")
    private BigDecimal amountBorrowed;

    @ApiModelProperty(value = "预付款项")
    private BigDecimal prepayment;

    @ApiModelProperty(value = "物流供应商预付款项")
    private BigDecimal logisticsPrepayment;

    @ApiModelProperty(value = "成品供应商预付款项")
    private BigDecimal finishedPrepayment;

    @ApiModelProperty(value = "半成品供应商预付款项")
    private BigDecimal semiPrepayment;

    @ApiModelProperty(value = "其他应收款")
    private BigDecimal otherAccountsReceivable;

    @ApiModelProperty(value = "存货余额/库存金额")
    private BigDecimal inventoryAmount;

    @ApiModelProperty(value = "FBA库存金额")
    private BigDecimal fbaInventoryAmount;

    @ApiModelProperty(value = "非FBA库存金额")
    private BigDecimal notFbaInventoryAmount;

    @ApiModelProperty(value = "非FBA耗材库存金额")
    private BigDecimal notFbaHcInventoryAmount;

    @ApiModelProperty(value = "FBA在途金额(调拨+采购)")
    private BigDecimal fbaTransferAmount;

    @ApiModelProperty(value = "非FBA在途金额(调拨+采购)")
    private BigDecimal notFbaTransferAmount;

    @ApiModelProperty(value = "FBA在途金额(调拨不包含计划)")
    private BigDecimal fbaTransferAllotAmount;

    @ApiModelProperty(value = "非FBA在途金额(调拨不包含计划)")
    private BigDecimal notFbaTransferAllotAmount;

    @ApiModelProperty(value = "FBA在途金额(调拨计划)")
    private BigDecimal fbaTransferPlanAmount;

    @ApiModelProperty(value = "非FBA在途金额(调拨计划)")
    private BigDecimal notFbaTransferPlanAmount;

    @ApiModelProperty(value = "FBA在途金额(采购)")
    private BigDecimal fbaPurchaseAmount;

    @ApiModelProperty(value = "非FBA在途金额(采购)")
    private BigDecimal notFbaPurchaseAmount;

    @ApiModelProperty(value = "生产采购发货在途金额")
    private BigDecimal purchaseProAmount;

    @ApiModelProperty(value = "半成品在库金额")
    private BigDecimal semiInventoryAmount;

    @ApiModelProperty(value = "半成品在途金额")
    private BigDecimal semiTransferAmount;

    @ApiModelProperty(value = "百伦半成品在库金额")
    private BigDecimal semiBailunInventoryAmount;

    @ApiModelProperty(value = "哈尼曼半成品在库金额")
    private BigDecimal semiHaniInventoryAmount;

    @ApiModelProperty(value = "百伦半成品在途金额")
    private BigDecimal semiBailunTransferAmount;

    @ApiModelProperty(value = "哈尼曼半成品在途金额")
    private BigDecimal semiHaniTransferAmount;

    @ApiModelProperty(value = "半成品生产在库金额")
    private BigDecimal semiProdInventoryAmount;

    @ApiModelProperty(value = "固定资产")
    private BigDecimal fixedAssets;

    @ApiModelProperty(value = "短期借款")
    private BigDecimal shortTermBorrow;

    @ApiModelProperty(value = "应付账款")
    private BigDecimal accountsPayable;

    @ApiModelProperty(value = "物流供应商应付账款")
    private BigDecimal logisticsAccountsPayable;

    @ApiModelProperty(value = "成品供应商应付账款")
    private BigDecimal finishedAccountsPayable;

    @ApiModelProperty(value = "半成品供应商应付账款")
    private BigDecimal semiAccountsPayable;

    @ApiModelProperty(value = "预收款项")
    private BigDecimal advanceReceived;

    @ApiModelProperty(value = "应付职工薪酬")
    private BigDecimal payableRemuneration;

    @ApiModelProperty(value = "应交税费")
    private BigDecimal taxesPayable;

    @ApiModelProperty(value = "其他应付款")
    private BigDecimal otherAccountsPayable;

    @ApiModelProperty(value = "长期应付款")
    private BigDecimal longTermAccountsPayable;

    @ApiModelProperty(value = "统计时间")
    private LocalDate statisticalTime;

    @ApiModelProperty(value = "取数时间")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "（流动资产）交易性金融资金")
    private BigDecimal faTradingFinanAsset;

    @ApiModelProperty(value = "应收票据")
    private BigDecimal faBillReceivable;

    @ApiModelProperty(value = "应收利息")
    private BigDecimal faInterestReceivable;

    @ApiModelProperty(value = "应收股利")
    private BigDecimal faDividendsReceivable;

    @ApiModelProperty(value = "一年内到期的非流动资产")
    private BigDecimal faOneyearNoncurrentAssets;

    @ApiModelProperty(value = "其他流动资产")
    private BigDecimal faOtherAssets;

    @ApiModelProperty(value = "流动资产合计")
    private BigDecimal faCount;

    @ApiModelProperty(value = "可供出售金融资产")
    private BigDecimal ncaAvaiForSaleFassets;

    @ApiModelProperty(value = "持有至到期的投资")
    private BigDecimal ncaHeldonInvestment;

    @ApiModelProperty(value = "长期应收款")
    private BigDecimal ncaLongtermReceivable;

    @ApiModelProperty(value = "长期股权投资")
    private BigDecimal ncaLongtermEquityInvestment;

    @ApiModelProperty(value = "投资性房地产")
    private BigDecimal ncaInvestmentProperty;

    @ApiModelProperty(value = "在建工程")
    private BigDecimal ncaConstructionInProcess;

    @ApiModelProperty(value = "工程物资")
    private BigDecimal ncaEngineeringMaterial;

    @ApiModelProperty(value = "固定资产清理")
    private BigDecimal ncaDisposalOfFixedAssets;

    @ApiModelProperty(value = "生产性生物资产")
    private BigDecimal ncaProductiveBiologicalAsset;

    @ApiModelProperty(value = "油气资产")
    private BigDecimal ncaOilAndGasAssets;

    @ApiModelProperty(value = "无形资产")
    private BigDecimal ncaIntangibleAssets;

    @ApiModelProperty(value = "开发支出")
    private BigDecimal ncaDevelopmentExpenditure;

    @ApiModelProperty(value = "商誉")
    private BigDecimal ncaGoodwill;

    @ApiModelProperty(value = "长期待摊费用")
    private BigDecimal ncaLongtermUnamortizedExpenses;

    @ApiModelProperty(value = "递延所得税资产")
    private BigDecimal ncaDeferredTaxAssets;

    @ApiModelProperty(value = "其他非流动资产")
    private BigDecimal ncaOtherAssets;

    @ApiModelProperty(value = "非流动资产合计")
    private BigDecimal ncaCount;

    @ApiModelProperty(value = "资产合计")
    private BigDecimal countAssets;

    @ApiModelProperty(value = "交易性金融负债")
    private BigDecimal clTradingFinancLiabilities;

    @ApiModelProperty(value = "应付票据")
    private BigDecimal clNotesPayable;

    @ApiModelProperty(value = "应付利息")
    private BigDecimal clPayableInterest;

    @ApiModelProperty(value = "应付股利")
    private BigDecimal clDividendsPayable;

    @ApiModelProperty(value = "一年内到期的非流动负债")
    private BigDecimal clOneyearNoncurrentLiabilities;

    @ApiModelProperty(value = "其他流动负债")
    private BigDecimal clOtherLiabilities;

    @ApiModelProperty(value = "流动负债合计")
    private BigDecimal clCount;

    @ApiModelProperty(value = "长期借款")
    private BigDecimal nclLongtermLoan;

    @ApiModelProperty(value = "应付债券")
    private BigDecimal nclBondsPayable;

    @ApiModelProperty(value = "专项应付款")
    private BigDecimal nclSpecialPayable;

    @ApiModelProperty(value = "预计负债")
    private BigDecimal nclAnticipationLiabilities;

    @ApiModelProperty(value = "递延所得税负债")
    private BigDecimal nclDeferredIncomeTaxLiabilities;

    @ApiModelProperty(value = "其他非流动负债")
    private BigDecimal nclOtherLiabilities;

    @ApiModelProperty(value = "非流动负债合计")
    private BigDecimal nclCount;

    @ApiModelProperty(value = "负债合计")
    private BigDecimal countLiabilities;

    @ApiModelProperty(value = "实收资本")
    private BigDecimal oePaiclUpCapital;

    @ApiModelProperty(value = "资本公积")
    private BigDecimal oeCapitalReserve;

    @ApiModelProperty(value = "(减)库存额")
    private BigDecimal oeInventoryAmount;

    @ApiModelProperty(value = "盈余公积")
    private BigDecimal oeSurplusPublicAccumulation;

    @ApiModelProperty(value = "未分配利润")
    private BigDecimal oeUndistributedProfit;

    @ApiModelProperty(value = "所有者权益合计")
    private BigDecimal oeCount;

    @ApiModelProperty(value = "负债和所有者权益合计")
    private BigDecimal countLiabilitiesAndOe;

    private BigDecimal accountsReceivableUpdate;

    @ApiModelProperty(value = "应收款项-导入")
    private BigDecimal accountsReceivableImport;

    @ApiModelProperty(value = "其他应收款项-导入")
    private BigDecimal otherAccountsReceivableImport;

    @ApiModelProperty(value = "其他应付-导入")
    private BigDecimal otherAccountsPayableImport;

    @ApiModelProperty(value = "固定资产-导入")
    private BigDecimal fixedAssetsImport;

    @ApiModelProperty(value = "递延所得税资产-导入")
    private BigDecimal ncaDeferredTaxAssetsImport;


}
