package com.bailuntec.task.job;

import com.bailuntec.domain.DcBaseCompanyAccount;
import com.bailuntec.domain.EbayAccountReportTask;
import com.bailuntec.task.listener.TaskListener;
import com.bailuntec.task.processor.CustomerProcessor;
import com.bailuntec.task.reader.CustomerReader;
import com.bailuntec.task.writer.CustomerWriter;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.cloud.task.configuration.EnableTask;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/1/19 1:37 下午
 */
@EnableTask
@Configuration
@EnableBatchProcessing
public class JobConfiguration {

    @Resource
    public JobBuilderFactory jobBuilderFactory;
    @Resource
    public StepBuilderFactory stepBuilderFactory;
    @Resource
    TaskListener taskListener;
    @Resource
    CustomerReader customerReader;
    @Resource
    CustomerProcessor customerProcessor;
    @Resource
    CustomerWriter customerWriter;


    @Bean
    public Job dataHandleJob() {
        return jobBuilderFactory.get("dataHandleJob")
                .incrementer(new RunIdIncrementer())
                .listener(taskListener)
                .start(handleDataStep())   //start是JOB执行的第一个step
                .build();
    }

    @Bean
    public Step handleDataStep() {
        return stepBuilderFactory.get("getData")
                .<DcBaseCompanyAccount, EbayAccountReportTask>chunk(100)        // <输入,输出> 。chunk通俗的讲类似于SQL的commit; 这里表示处理(processor)100条后写入(writer)一次。
                .reader(customerReader)         //指定ItemReader
                .processor(customerProcessor)   //指定ItemProcessor
                .writer(customerWriter)//指定ItemWriter
                .build();
    }


}
