package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 自动周转特殊销量设置, 需提前一个周转期配置(或者说只能配置下一个周转期的活动)
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcAutoConfigPromotion对象", description="自动周转特殊销量设置, 需提前一个周转期配置(或者说只能配置下一个周转期的活动)")
public class DcAutoConfigPromotion implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    private LocalDateTime gmtCreate;

    private LocalDateTime gmtModified;

    private String bailunSku;

    @ApiModelProperty(value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(value = "数量")
    private Integer count;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "促销时间(单日)")
    private LocalDate promotionTime;

    @ApiModelProperty(value = "0：默认, 1：有关联采购建议，2：作废 ")
    private Integer status;

    @ApiModelProperty(value = "审核员")
    private String blAuditor;

    @ApiModelProperty(value = "操作员")
    private String blOperator;


}
