package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 海外仓FBA仓入库天数设定
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcAutoConfigDelivery对象", description="海外仓FBA仓入库天数设定")
public class DcAutoConfigDelivery implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "数据中心创建时间")
    private LocalDateTime gmtCreate;

    @ApiModelProperty(value = "数据中心更新时间")
    private LocalDateTime gmtModified;

    @ApiModelProperty(value = "仓库编码或者仓库类型")
    private String variableCode;

    @ApiModelProperty(value = "仓库编码或者仓库类型")
    private String variableName;

    @ApiModelProperty(value = "类型(1.仓库编码+SKU ,2.仓库类型+SKU 3. 仓库编码, 4 .仓库类型)")
    private Integer type;

    @ApiModelProperty(value = "操作员")
    private String blOperator;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "1启用, 2停用")
    private Integer status;

    @ApiModelProperty(value = "调拨打包")
    private Integer tranferBale;

    @ApiModelProperty(value = "调拨头程")
    private Integer tranferHead;

    @ApiModelProperty(value = "海外仓入库")
    private Integer abroadInbound;

    @ApiModelProperty(value = "百伦SKU")
    private String bailunSku;


}
