package com.bailuntec.infrastructure.mapper;

import com.bailuntec.domain.DcWithdrawOnWay;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * <p>
 * 银行账号平台提现在途表 Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-11-03
 */
public interface DcWithdrawOnWayMapper extends BaseMapper<DcWithdrawOnWay> {

    @Update("update dc_withdraw_on_way w" +
            " inner join dc_bank_account_balance b on w.pay_account_id = b.pay_account_id and w.statistical_time = b.statistical_time " +
            " set w.company_value = b.company_value")
    void updateWithdrawOnWayCompany();

    @Select("select ifnull(sum(amount_rmb),0) from dc_withdraw_on_way where statistical_time = #{lastDay}")
    BigDecimal getWithdrawOnWaySum(@Param("lastDay") LocalDate lastDay);
}
