package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 基础SKU简单分类表
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseSkuSimpleCategory对象", description="基础SKU简单分类表")
public class DcBaseSkuSimpleCategory implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "父类id")
    private Integer parentId;

    @ApiModelProperty(value = "简单分类短名称")
    private String name;

    @ApiModelProperty(value = "简单分类全名称")
    private String fullName;

    @ApiModelProperty(value = "级别")
    private Integer level;

    @ApiModelProperty(value = "简单分类Id")
    private Integer skumsId;

    @ApiModelProperty(value = "数据中心创建时间")
    private LocalDateTime bjCreate;

    @ApiModelProperty(value = "数据中心更新时间")
    private LocalDateTime bjModified;


}
