package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * paypal帐号信息
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBasePaypalAccount对象", description="paypal帐号信息")
public class DcBasePaypalAccount implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "帐号/卖家名称")
    private String seller;

    @ApiModelProperty(value = "账号密码")
    private String sellerPassword;

    @ApiModelProperty(value = "账号持有人")
    private String sellerUser;

    @ApiModelProperty(value = "简称")
    private String abbreviation;

    @ApiModelProperty(value = "手机号码")
    private String phoneNumber;

    @ApiModelProperty(value = "手机号码持有人")
    private String phoneNumberUser;

    @ApiModelProperty(value = "商家名称")
    private String merchant;

    @ApiModelProperty(value = "信用卡")
    private String creditCard;

    @ApiModelProperty(value = "信用卡持有人")
    private String creditCardUser;

    @ApiModelProperty(value = "信用卡过期时间")
    private LocalDateTime creditCardExpirationDate;

    @ApiModelProperty(value = "提现银行")
    private String withdrawBank;

    @ApiModelProperty(value = "API用户名")
    private String apiUserName;

    @ApiModelProperty(value = "API密码")
    private String apiPassword;

    @ApiModelProperty(value = "API签名")
    private String apiSignature;

    @ApiModelProperty(value = "token json")
    private String authJson;

    @ApiModelProperty(value = "授权时间")
    private LocalDateTime authTime;

    @ApiModelProperty(value = "token失效时间")
    private LocalDateTime authTokenExpireTime;

    @ApiModelProperty(value = "创建人Id")
    private Integer createUserId;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "修改人Id")
    private Integer modifyUserId;

    @ApiModelProperty(value = "修改人")
    private String modifyUserName;

    @ApiModelProperty(value = "修改时间")
    private LocalDateTime modifyTime;

    private Integer companyId;

    @ApiModelProperty(value = "接口数据id")
    private Integer paypalId;


}
