package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 销量上限设定
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcAutoConfigSalesUpperLimit对象", description="销量上限设定")
public class DcAutoConfigSalesUpperLimit implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "数据中心创建时间")
    private LocalDateTime gmtCreate;

    @ApiModelProperty(value = "数据中心更新时间")
    private LocalDateTime gmtModified;

    @ApiModelProperty(value = "销量上限固定值或者加权倍数")
    private BigDecimal param;

    @ApiModelProperty(value = "SKU或分类id")
    private String variableCode;

    @ApiModelProperty(value = "SKU名称或分类名称")
    private String variableName;

    @ApiModelProperty(value = "类型(1.仓库+SKU ,2.仓库+ 分类 11. 按历史加权平均计算)")
    private Integer type;

    @ApiModelProperty(value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(value = "操作员")
    private String blOperator;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "1启用, 2停用")
    private Integer status;

    @ApiModelProperty(value = "7天加权系数")
    private BigDecimal weightingCoefficientSeven;

    @ApiModelProperty(value = "十四天加权系数")
    private BigDecimal weightingCoefficientFourteen;

    @ApiModelProperty(value = "三十天加权系数")
    private BigDecimal weightingCoefficientThirty;


}
