package com.bailuntec.mq.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bailuntec.application.IDcBaseStockService;
import com.bailuntec.common.rabbitmq.listen.AbstractMessageHandler;
import com.bailuntec.pojo.WmsStockItem;
import com.rabbitmq.client.Channel;
import lombok.SneakyThrows;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in 2021-11-18
 * @Modified by:
 */
@Component
public class WmsStockMsgHandler extends AbstractMessageHandler {

    @Resource
    IDcBaseStockService dcBaseStockService;

    private static boolean IS_INIT = false;

    @PostConstruct
    public void init(){
        IS_INIT = true;
    }

    @SneakyThrows
    @Override
    public void handleMessage(String s, Channel channel) {
        JSONObject jsonObject = JSON.parseObject(s);
        WmsStockItem wmsStockItem = jsonObject.toJavaObject(WmsStockItem.class);
        while (!IS_INIT){
            Thread.sleep(1000);
        }
        //IDcBaseStockService dcBaseStockService = SpringContextUtil.getBean(DcBaseStockServiceImpl.class);
        dcBaseStockService.syncWmsStock(wmsStockItem);
    }
}
