package com.bailuntec.job.service;

import com.bailuntec.BalanceSheetApp;
import com.bailuntec.domain.DcJobConfig;
import com.bailuntec.infrastructure.mapper.DcJobConfigMapper;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import javax.annotation.Resource;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/11/3 5:10 下午
 */
@ActiveProfiles("test")
@RunWith(SpringRunner.class)
@SpringBootTest(classes = BalanceSheetApp.class)
@WebAppConfiguration
public class BalanceSheetServiceTest {

    @Resource
    BalanceSheetService balanceSheetService;

    @Resource
    DcJobConfigMapper dcJobConfigMapper;

    @Test
    public void syncBankAccount() {
        //balanceSheetService.syncBankAccount();
    }

    /*@Test
    public void syncWithdrawOnWaySummary() {
        balanceSheetService.syncWithdrawOnWaySummary();
    }

    @Test
    public void syncShortBorrowBalance() {
        balanceSheetService.syncShortBorrowBalance();
    }

    @Test
    public void syncCost() {
        balanceSheetService.syncCost();
    }

    @Test
    public void syncBuy() throws ParseException {
        balanceSheetService.syncBuy();
    }

    @Test
    public void syncPayPal() {
        balanceSheetService.syncPayPal();
    }

    @Test
    public void syncSemiInventoryBalance() {
        balanceSheetService.syncSemiInventoryBalance();
    }

    @Test
    @Rollback(value = false)
    public void generateBalanceSheet() {
        balanceSheetService.getSupplierTransaction();
        //LocalDate date = LocalDate.now().minusDays(1);
        //balanceSheetService.getSupplierTransaction();
    }*/

    @Test
    public void balanceSheetTest() throws ParseException {
        for(long minus=4;minus>1;minus--) {
            //long minus = 5;
            LocalDate localDate = LocalDate.now().minusDays(minus);
            LocalDateTime localDateTime = LocalDateTime.now().minusDays(minus);
            balanceSheetService.syncBankAccount(localDate);
            balanceSheetService.syncWithdrawOnWaySummary(localDate);
            balanceSheetService.syncPayPal(localDateTime);
            balanceSheetService.syncShortBorrowBalance(localDate);
            balanceSheetService.syncCost(localDate);
            balanceSheetService.syncBuy(localDate);
            balanceSheetService.syncSemiInventoryBalance(localDate);
            balanceSheetService.generateBalanceSheet(localDate);
            balanceSheetService.getSupplierTransaction(localDate);
        }
    }

    @Test
    public void test(){
        /*System.out.println("----------------------------------");
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName("finance-generate-balance-sheet");
        dcJobConfig.setStartTime(LocalDateTime.of(2021,3,18,0,0));
        balanceSheetService.getSemiInventoryBalance(dcJobConfig);*/
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName("finance-generate-balance-sheet");
        //Date lastDay = Date.from(dcJobConfig.getStartTime().toInstant(ZoneOffset.ofHours(8)));
        dcJobConfig.setStartTime(dcJobConfig.getStartTime().plusHours(-5));
        Date lastDay = java.sql.Date.valueOf(dcJobConfig.getStartTime().toLocalDate());
        System.out.println(lastDay);
    }
}
