package com.bailuntec.infrastructure.mapper;

import com.bailuntec.domain.DcShortTermBorrow;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * <p>
 * 公司主体短期借款表 Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-11-03
 */
public interface DcShortTermBorrowMapper extends BaseMapper<DcShortTermBorrow> {
    /**
     * 短期借款总额
     *
     * @param lastDay 日期
     * @return 短期借款总额
     */
    @Select("select ifnull(sum(balance_rmb),0) from dc_short_term_borrow where statistical_time = #{lastDay}")
    BigDecimal getShortTermBorrowBalanceSum(@Param("lastDay") LocalDate lastDay);
}
