package com.bailuntec.infrastructure.mapper;

import com.bailuntec.domain.DcInventoryBalance;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * <p>
 * 存货余额表 Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-11-11
 */
public interface DcInventoryBalanceMapper extends BaseMapper<DcInventoryBalance> {


    @Delete("delete from dc_inventory_balance where statistical_time =#{lastDay} ")
    void deleteInventoryBalance(LocalDate lastDay);

    //插入库存明细
    @Insert("insert ignore into dc_inventory_balance(warehouse_code,warehouse_name,hq_type,balance_rmb,statistical_time,is_transfer)" +
            " select ds.warehouse_code,w.warehouse_name,w.hq_type,sum(ds.unit_price * (ds.usable_stock + ds.occupy_stock)),#{lastDay},0" +
            " from dc_daily_stock ds left join dc_base_sku s on ds.bailun_sku = s.bailun_sku" +
            " left join dc_base_warehouse w on ds.warehouse_code = w.warehouse_code" +
            " where ds.record_time = #{lastDay}" +
            " group by ds.warehouse_code,w.warehouse_name,w.hq_type")
    void insertInventoryBalance(@Param("lastDay") LocalDate lastDay);

    //插入调拨在途明细
    @Insert("insert ignore into dc_inventory_balance(warehouse_code,warehouse_name,hq_type,balance_rmb,statistical_time,is_transfer,transfer_rmb,transfer_plan_rmb,purchase_rmb)" +
            " select t.warehouse_code,w.warehouse_name,w.hq_type,sum((t.unit_price * t.quantity_transfer) + (t.unit_price * t.quantity_purchase))," +
            "#{lastDay},1,sum(t.unit_price * (t.quantity_transfer - t.quantity_transfer_plan)),sum(t.unit_price * t.quantity_transfer_plan)," +
            "sum(t.unit_price * t.quantity_purchase)" +
            " from dc_daily_transit t left join dc_base_sku s on t.bailun_sku = s.bailun_sku" +
            " left join dc_base_warehouse w on t.warehouse_code = w.warehouse_code" +
            " where t.record_time = #{lastDay}" +
            " group by t.warehouse_code,w.warehouse_name,w.hq_type")
    void insertTransferInventoryBalance(@Param("lastDay") LocalDate lastDay);

    //fba 在库金额
    @Select("select ifnull(sum(balance_rmb),0) from dc_inventory_balance where statistical_time = #{lastDay} and hq_type='FBA仓' and is_transfer=0")
    BigDecimal getFbaInventoryAmountSum(LocalDate lastDay);

    // 非FBA在库金额(不包含耗材仓)
    @Select("select ifnull(sum(balance_rmb),0) from dc_inventory_balance where statistical_time = #{lastDay} and hq_type<>'FBA仓' and hq_type<>'耗材仓' and is_transfer=0")
    BigDecimal getNotFbaInventoryAmountSum(@Param("lastDay") LocalDate lastDay);

    // 非FBA在库金额(耗材仓)
    @Select("select ifnull(sum(balance_rmb),0) from dc_inventory_balance where statistical_time = #{lastDay} and hq_type<>'FBA仓' and hq_type = '耗材仓' and is_transfer=0")
    BigDecimal getNotFbaHcInventoryAmountSum(@Param("lastDay") LocalDate lastDay);

    // FBA在途
    @Select("select ifnull(sum(balance_rmb),0) from dc_inventory_balance where statistical_time = #{lastDay} and hq_type='FBA仓' and is_transfer=1")
    BigDecimal getFbaTransferAmountSum(@Param("lastDay") LocalDate lastDay);

    // 非FBA在途金额(调拨+采购)
    @Select("select ifnull(sum(balance_rmb),0) from dc_inventory_balance where statistical_time = #{lastDay} and hq_type<>'FBA仓' and is_transfer=1")
    BigDecimal getNotFbaTransferAmountSum(@Param("lastDay") LocalDate lastDay);

    // FBA调拨在途金额(调拨不包含计划)
    @Select("select ifnull(sum(transfer_rmb),0) from dc_inventory_balance where statistical_time = #{lastDay} and hq_type='FBA仓' and is_transfer=1")
    BigDecimal getFbaTransferAllotAmountSum(@Param("lastDay") LocalDate lastDay);

    // 非FBA调拨在途金额(调拨不包含计划)
    @Select("select ifnull(sum(transfer_rmb),0) from dc_inventory_balance where statistical_time = #{lastDay} and hq_type<>'FBA仓' and is_transfer=1")
    BigDecimal getNotFbaTransferAllotAmountSum(@Param("lastDay") LocalDate lastDay);

    // FBA调拨计划在途金额
    @Select("select ifnull(sum(transfer_plan_rmb),0) from dc_inventory_balance where statistical_time = #{lastDay} and hq_type='FBA仓' and is_transfer=1")
    BigDecimal getFbaTransferPlanAmountSum(@Param("lastDay") LocalDate lastDay);

    // 非FBA调拨计划在途金额
    @Select("select ifnull(sum(transfer_plan_rmb),0) from dc_inventory_balance where statistical_time = #{lastDay} and hq_type<>'FBA仓' and is_transfer=1")
    BigDecimal getNotFbaTransferPlanAmountSum(@Param("lastDay") LocalDate lastDay);

    // FBA采购在途金额
    @Select("select ifnull(sum(purchase_rmb),0) from dc_inventory_balance where statistical_time = #{lastDay} and hq_type='FBA仓' and is_transfer=1")
    BigDecimal getFbaPurchaseAmountSum(@Param("lastDay") LocalDate lastDay);

    // 非FBA采购在途金额
    @Select("select ifnull(sum(purchase_rmb),0) from dc_inventory_balance where statistical_time = #{lastDay} and hq_type<>'FBA仓' and is_transfer=1")
    BigDecimal getNotFbaPurchaseAmountSum(@Param("lastDay") LocalDate lastDay);

    // 自产采购在途金额
    @Select("select ifnull(sum(t1.count * t1.price),0) amount from dc_daily_purchase_semi_deliveronway t1 where t1.day= #{lastDay}")
    BigDecimal getPurchaseProAmount(@Param("lastDay") LocalDate lastDay);

}
