package com.bailuntec.infrastructure.mapper;

import com.bailuntec.domain.DcDailyTransit;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 在途数据每日表 Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-12-10
 */
public interface DcDailyTransitMapper extends BaseMapper<DcDailyTransit> {

    /**
     * 清空昨天的在途每日数据快照
     */
    void clearSnapShot();

    /**
     * 分页查询每日在途数据
     *
     * @param pageStart  pageStart
     * @param pageOffset pageOffset
     * @return 每日在途数据
     */
    List<DcDailyTransit> selectSnapShot(@Param("pageStart") int pageStart, @Param("pageOffset") int pageOffset);
}
